package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.ResourceARN
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class LambdaOutputUpdate(resourceARNUpdate: ResourceARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.LambdaOutputUpdate = {
    import LambdaOutputUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.LambdaOutputUpdate
      .builder()
      .resourceARNUpdate(
        ResourceARN.unwrap(resourceARNUpdate): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalyticsv2.model.LambdaOutputUpdate.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.LambdaOutputUpdate.wrap(buildAwsValue())
}
object LambdaOutputUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.LambdaOutputUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.LambdaOutputUpdate =
      zio.aws.kinesisanalyticsv2.model.LambdaOutputUpdate(resourceARNUpdate)
    def resourceARNUpdate: ResourceARN
    def getResourceARNUpdate: ZIO[Any, Nothing, ResourceARN] =
      ZIO.succeed(resourceARNUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.LambdaOutputUpdate
  ) extends zio.aws.kinesisanalyticsv2.model.LambdaOutputUpdate.ReadOnly {
    override val resourceARNUpdate: ResourceARN =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ResourceARN(impl.resourceARNUpdate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.LambdaOutputUpdate
  ): zio.aws.kinesisanalyticsv2.model.LambdaOutputUpdate.ReadOnly = new Wrapper(
    impl
  )
}
