package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  MinPauseBetweenCheckpoints,
  CheckpointInterval,
  BooleanObject
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CheckpointConfigurationUpdate(
    configurationTypeUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.ConfigurationType
    ] = Optional.Absent,
    checkpointingEnabledUpdate: Optional[BooleanObject] = Optional.Absent,
    checkpointIntervalUpdate: Optional[CheckpointInterval] = Optional.Absent,
    minPauseBetweenCheckpointsUpdate: Optional[MinPauseBetweenCheckpoints] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.CheckpointConfigurationUpdate = {
    import CheckpointConfigurationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CheckpointConfigurationUpdate
      .builder()
      .optionallyWith(configurationTypeUpdate.map(value => value.unwrap))(
        _.configurationTypeUpdate
      )
      .optionallyWith(
        checkpointingEnabledUpdate.map(value => value: java.lang.Boolean)
      )(_.checkpointingEnabledUpdate)
      .optionallyWith(
        checkpointIntervalUpdate.map(value =>
          CheckpointInterval.unwrap(value): java.lang.Long
        )
      )(_.checkpointIntervalUpdate)
      .optionallyWith(
        minPauseBetweenCheckpointsUpdate.map(value =>
          MinPauseBetweenCheckpoints.unwrap(value): java.lang.Long
        )
      )(_.minPauseBetweenCheckpointsUpdate)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationUpdate.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationUpdate
      .wrap(buildAwsValue())
}
object CheckpointConfigurationUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CheckpointConfigurationUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationUpdate =
      zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationUpdate(
        configurationTypeUpdate.map(value => value),
        checkpointingEnabledUpdate.map(value => value),
        checkpointIntervalUpdate.map(value => value),
        minPauseBetweenCheckpointsUpdate.map(value => value)
      )
    def configurationTypeUpdate
        : Optional[zio.aws.kinesisanalyticsv2.model.ConfigurationType]
    def checkpointingEnabledUpdate: Optional[BooleanObject]
    def checkpointIntervalUpdate: Optional[CheckpointInterval]
    def minPauseBetweenCheckpointsUpdate: Optional[MinPauseBetweenCheckpoints]
    def getConfigurationTypeUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ConfigurationType
    ] = AwsError.unwrapOptionField(
      "configurationTypeUpdate",
      configurationTypeUpdate
    )
    def getCheckpointingEnabledUpdate: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField(
        "checkpointingEnabledUpdate",
        checkpointingEnabledUpdate
      )
    def getCheckpointIntervalUpdate: ZIO[Any, AwsError, CheckpointInterval] =
      AwsError.unwrapOptionField(
        "checkpointIntervalUpdate",
        checkpointIntervalUpdate
      )
    def getMinPauseBetweenCheckpointsUpdate
        : ZIO[Any, AwsError, MinPauseBetweenCheckpoints] =
      AwsError.unwrapOptionField(
        "minPauseBetweenCheckpointsUpdate",
        minPauseBetweenCheckpointsUpdate
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CheckpointConfigurationUpdate
  ) extends zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationUpdate.ReadOnly {
    override val configurationTypeUpdate
        : Optional[zio.aws.kinesisanalyticsv2.model.ConfigurationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationTypeUpdate())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.ConfigurationType.wrap(value)
        )
    override val checkpointingEnabledUpdate: Optional[BooleanObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.checkpointingEnabledUpdate())
        .map(value => value: BooleanObject)
    override val checkpointIntervalUpdate: Optional[CheckpointInterval] =
      zio.aws.core.internal
        .optionalFromNullable(impl.checkpointIntervalUpdate())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.primitives.CheckpointInterval(value)
        )
    override val minPauseBetweenCheckpointsUpdate
        : Optional[MinPauseBetweenCheckpoints] = zio.aws.core.internal
      .optionalFromNullable(impl.minPauseBetweenCheckpointsUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives
          .MinPauseBetweenCheckpoints(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CheckpointConfigurationUpdate
  ): zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationUpdate.ReadOnly =
    new Wrapper(impl)
}
