package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  ApplicationVersionId,
  ApplicationName
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AddApplicationOutputRequest(
    applicationName: ApplicationName,
    currentApplicationVersionId: ApplicationVersionId,
    output: zio.aws.kinesisanalyticsv2.model.Output
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationOutputRequest = {
    import AddApplicationOutputRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationOutputRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .currentApplicationVersionId(
        ApplicationVersionId.unwrap(currentApplicationVersionId): java.lang.Long
      )
      .output(output.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.AddApplicationOutputRequest.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.AddApplicationOutputRequest
      .wrap(buildAwsValue())
}
object AddApplicationOutputRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationOutputRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.AddApplicationOutputRequest =
      zio.aws.kinesisanalyticsv2.model.AddApplicationOutputRequest(
        applicationName,
        currentApplicationVersionId,
        output.asEditable
      )
    def applicationName: ApplicationName
    def currentApplicationVersionId: ApplicationVersionId
    def output: zio.aws.kinesisanalyticsv2.model.Output.ReadOnly
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getCurrentApplicationVersionId
        : ZIO[Any, Nothing, ApplicationVersionId] =
      ZIO.succeed(currentApplicationVersionId)
    def getOutput
        : ZIO[Any, Nothing, zio.aws.kinesisanalyticsv2.model.Output.ReadOnly] =
      ZIO.succeed(output)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationOutputRequest
  ) extends zio.aws.kinesisanalyticsv2.model.AddApplicationOutputRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationName(impl.applicationName())
    override val currentApplicationVersionId: ApplicationVersionId =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationVersionId(impl.currentApplicationVersionId())
    override val output: zio.aws.kinesisanalyticsv2.model.Output.ReadOnly =
      zio.aws.kinesisanalyticsv2.model.Output.wrap(impl.output())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationOutputRequest
  ): zio.aws.kinesisanalyticsv2.model.AddApplicationOutputRequest.ReadOnly =
    new Wrapper(impl)
}
