package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  SessionExpirationDurationInSeconds,
  ApplicationName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateApplicationPresignedUrlRequest(
    applicationName: ApplicationName,
    urlType: zio.aws.kinesisanalyticsv2.model.UrlType,
    sessionExpirationDurationInSeconds: Optional[
      SessionExpirationDurationInSeconds
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationPresignedUrlRequest = {
    import CreateApplicationPresignedUrlRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationPresignedUrlRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .urlType(urlType.unwrap)
      .optionallyWith(
        sessionExpirationDurationInSeconds.map(value =>
          SessionExpirationDurationInSeconds.unwrap(value): java.lang.Long
        )
      )(_.sessionExpirationDurationInSeconds)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.CreateApplicationPresignedUrlRequest.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.CreateApplicationPresignedUrlRequest
      .wrap(buildAwsValue())
}
object CreateApplicationPresignedUrlRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationPresignedUrlRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.CreateApplicationPresignedUrlRequest =
      zio.aws.kinesisanalyticsv2.model.CreateApplicationPresignedUrlRequest(
        applicationName,
        urlType,
        sessionExpirationDurationInSeconds.map(value => value)
      )
    def applicationName: ApplicationName
    def urlType: zio.aws.kinesisanalyticsv2.model.UrlType
    def sessionExpirationDurationInSeconds
        : Optional[SessionExpirationDurationInSeconds]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getUrlType
        : ZIO[Any, Nothing, zio.aws.kinesisanalyticsv2.model.UrlType] =
      ZIO.succeed(urlType)
    def getSessionExpirationDurationInSeconds
        : ZIO[Any, AwsError, SessionExpirationDurationInSeconds] =
      AwsError.unwrapOptionField(
        "sessionExpirationDurationInSeconds",
        sessionExpirationDurationInSeconds
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationPresignedUrlRequest
  ) extends zio.aws.kinesisanalyticsv2.model.CreateApplicationPresignedUrlRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationName(impl.applicationName())
    override val urlType: zio.aws.kinesisanalyticsv2.model.UrlType =
      zio.aws.kinesisanalyticsv2.model.UrlType.wrap(impl.urlType())
    override val sessionExpirationDurationInSeconds
        : Optional[SessionExpirationDurationInSeconds] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionExpirationDurationInSeconds())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives
          .SessionExpirationDurationInSeconds(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationPresignedUrlRequest
  ): zio.aws.kinesisanalyticsv2.model.CreateApplicationPresignedUrlRequest.ReadOnly =
    new Wrapper(impl)
}
