package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.DatabaseARN
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GlueDataCatalogConfigurationDescription(
    databaseARN: DatabaseARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.GlueDataCatalogConfigurationDescription = {
    import GlueDataCatalogConfigurationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.GlueDataCatalogConfigurationDescription
      .builder()
      .databaseARN(DatabaseARN.unwrap(databaseARN): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.GlueDataCatalogConfigurationDescription.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.GlueDataCatalogConfigurationDescription
      .wrap(buildAwsValue())
}
object GlueDataCatalogConfigurationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.GlueDataCatalogConfigurationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.GlueDataCatalogConfigurationDescription =
      zio.aws.kinesisanalyticsv2.model
        .GlueDataCatalogConfigurationDescription(databaseARN)
    def databaseARN: DatabaseARN
    def getDatabaseARN: ZIO[Any, Nothing, DatabaseARN] =
      ZIO.succeed(databaseARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.GlueDataCatalogConfigurationDescription
  ) extends zio.aws.kinesisanalyticsv2.model.GlueDataCatalogConfigurationDescription.ReadOnly {
    override val databaseARN: DatabaseARN =
      zio.aws.kinesisanalyticsv2.model.primitives
        .DatabaseARN(impl.databaseARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.GlueDataCatalogConfigurationDescription
  ): zio.aws.kinesisanalyticsv2.model.GlueDataCatalogConfigurationDescription.ReadOnly =
    new Wrapper(impl)
}
