package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  MinPauseBetweenCheckpoints,
  CheckpointInterval,
  BooleanObject
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CheckpointConfiguration(
    configurationType: zio.aws.kinesisanalyticsv2.model.ConfigurationType,
    checkpointingEnabled: Optional[BooleanObject] = Optional.Absent,
    checkpointInterval: Optional[CheckpointInterval] = Optional.Absent,
    minPauseBetweenCheckpoints: Optional[MinPauseBetweenCheckpoints] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.CheckpointConfiguration = {
    import CheckpointConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CheckpointConfiguration
      .builder()
      .configurationType(configurationType.unwrap)
      .optionallyWith(
        checkpointingEnabled.map(value => value: java.lang.Boolean)
      )(_.checkpointingEnabled)
      .optionallyWith(
        checkpointInterval.map(value =>
          CheckpointInterval.unwrap(value): java.lang.Long
        )
      )(_.checkpointInterval)
      .optionallyWith(
        minPauseBetweenCheckpoints.map(value =>
          MinPauseBetweenCheckpoints.unwrap(value): java.lang.Long
        )
      )(_.minPauseBetweenCheckpoints)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.CheckpointConfiguration.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.CheckpointConfiguration
      .wrap(buildAwsValue())
}
object CheckpointConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CheckpointConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.CheckpointConfiguration =
      zio.aws.kinesisanalyticsv2.model.CheckpointConfiguration(
        configurationType,
        checkpointingEnabled.map(value => value),
        checkpointInterval.map(value => value),
        minPauseBetweenCheckpoints.map(value => value)
      )
    def configurationType: zio.aws.kinesisanalyticsv2.model.ConfigurationType
    def checkpointingEnabled: Optional[BooleanObject]
    def checkpointInterval: Optional[CheckpointInterval]
    def minPauseBetweenCheckpoints: Optional[MinPauseBetweenCheckpoints]
    def getConfigurationType: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalyticsv2.model.ConfigurationType
    ] = ZIO.succeed(configurationType)
    def getCheckpointingEnabled: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("checkpointingEnabled", checkpointingEnabled)
    def getCheckpointInterval: ZIO[Any, AwsError, CheckpointInterval] =
      AwsError.unwrapOptionField("checkpointInterval", checkpointInterval)
    def getMinPauseBetweenCheckpoints
        : ZIO[Any, AwsError, MinPauseBetweenCheckpoints] =
      AwsError.unwrapOptionField(
        "minPauseBetweenCheckpoints",
        minPauseBetweenCheckpoints
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CheckpointConfiguration
  ) extends zio.aws.kinesisanalyticsv2.model.CheckpointConfiguration.ReadOnly {
    override val configurationType
        : zio.aws.kinesisanalyticsv2.model.ConfigurationType =
      zio.aws.kinesisanalyticsv2.model.ConfigurationType
        .wrap(impl.configurationType())
    override val checkpointingEnabled: Optional[BooleanObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.checkpointingEnabled())
        .map(value => value: BooleanObject)
    override val checkpointInterval: Optional[CheckpointInterval] =
      zio.aws.core.internal
        .optionalFromNullable(impl.checkpointInterval())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.primitives.CheckpointInterval(value)
        )
    override val minPauseBetweenCheckpoints
        : Optional[MinPauseBetweenCheckpoints] = zio.aws.core.internal
      .optionalFromNullable(impl.minPauseBetweenCheckpoints())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives
          .MinPauseBetweenCheckpoints(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CheckpointConfiguration
  ): zio.aws.kinesisanalyticsv2.model.CheckpointConfiguration.ReadOnly =
    new Wrapper(impl)
}
