package zio.aws.kinesisanalyticsv2.model
import scala.jdk.CollectionConverters.*
sealed trait ApplicationRestoreType {
  def unwrap: software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationRestoreType
}
object ApplicationRestoreType {
  def wrap(
      value: software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationRestoreType
  ): zio.aws.kinesisanalyticsv2.model.ApplicationRestoreType = value match {
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationRestoreType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationRestoreType.SKIP_RESTORE_FROM_SNAPSHOT =>
      val r = SKIP_RESTORE_FROM_SNAPSHOT
      r
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationRestoreType.RESTORE_FROM_LATEST_SNAPSHOT =>
      val r = RESTORE_FROM_LATEST_SNAPSHOT
      r
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationRestoreType.RESTORE_FROM_CUSTOM_SNAPSHOT =>
      val r = RESTORE_FROM_CUSTOM_SNAPSHOT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kinesisanalyticsv2.model.ApplicationRestoreType {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationRestoreType =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationRestoreType.UNKNOWN_TO_SDK_VERSION
  }
  case object SKIP_RESTORE_FROM_SNAPSHOT
      extends zio.aws.kinesisanalyticsv2.model.ApplicationRestoreType {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationRestoreType =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationRestoreType.SKIP_RESTORE_FROM_SNAPSHOT
  }
  case object RESTORE_FROM_LATEST_SNAPSHOT
      extends zio.aws.kinesisanalyticsv2.model.ApplicationRestoreType {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationRestoreType =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationRestoreType.RESTORE_FROM_LATEST_SNAPSHOT
  }
  case object RESTORE_FROM_CUSTOM_SNAPSHOT
      extends zio.aws.kinesisanalyticsv2.model.ApplicationRestoreType {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationRestoreType =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationRestoreType.RESTORE_FROM_CUSTOM_SNAPSHOT
  }
}
