package zio.aws.kinesisanalyticsv2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kinesisanalyticsv2.model.primitives.InputParallelismCount
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class InputParallelism(
    count: Optional[InputParallelismCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.InputParallelism = {
    import InputParallelism.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.InputParallelism
      .builder()
      .optionallyWith(
        count.map(value => InputParallelismCount.unwrap(value): Integer)
      )(_.count)
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalyticsv2.model.InputParallelism.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.InputParallelism.wrap(buildAwsValue())
}
object InputParallelism {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.InputParallelism
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.InputParallelism =
      zio.aws.kinesisanalyticsv2.model
        .InputParallelism(count.map(value => value))
    def count: Optional[InputParallelismCount]
    def getCount: ZIO[Any, AwsError, InputParallelismCount] =
      AwsError.unwrapOptionField("count", count)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.InputParallelism
  ) extends zio.aws.kinesisanalyticsv2.model.InputParallelism.ReadOnly {
    override val count: Optional[InputParallelismCount] = zio.aws.core.internal
      .optionalFromNullable(impl.count())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.InputParallelismCount(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.InputParallelism
  ): zio.aws.kinesisanalyticsv2.model.InputParallelism.ReadOnly = new Wrapper(
    impl
  )
}
