package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FlinkApplicationConfigurationUpdate(
    checkpointConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationUpdate
    ] = Optional.Absent,
    monitoringConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.MonitoringConfigurationUpdate
    ] = Optional.Absent,
    parallelismConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.ParallelismConfigurationUpdate
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.FlinkApplicationConfigurationUpdate = {
    import FlinkApplicationConfigurationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.FlinkApplicationConfigurationUpdate
      .builder()
      .optionallyWith(
        checkpointConfigurationUpdate.map(value => value.buildAwsValue())
      )(_.checkpointConfigurationUpdate)
      .optionallyWith(
        monitoringConfigurationUpdate.map(value => value.buildAwsValue())
      )(_.monitoringConfigurationUpdate)
      .optionallyWith(
        parallelismConfigurationUpdate.map(value => value.buildAwsValue())
      )(_.parallelismConfigurationUpdate)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationUpdate.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationUpdate
      .wrap(buildAwsValue())
}
object FlinkApplicationConfigurationUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.FlinkApplicationConfigurationUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationUpdate =
      zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationUpdate(
        checkpointConfigurationUpdate.map(value => value.asEditable),
        monitoringConfigurationUpdate.map(value => value.asEditable),
        parallelismConfigurationUpdate.map(value => value.asEditable)
      )
    def checkpointConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationUpdate.ReadOnly
    ]
    def monitoringConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.MonitoringConfigurationUpdate.ReadOnly
    ]
    def parallelismConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.ParallelismConfigurationUpdate.ReadOnly
    ]
    def getCheckpointConfigurationUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "checkpointConfigurationUpdate",
      checkpointConfigurationUpdate
    )
    def getMonitoringConfigurationUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.MonitoringConfigurationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "monitoringConfigurationUpdate",
      monitoringConfigurationUpdate
    )
    def getParallelismConfigurationUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ParallelismConfigurationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "parallelismConfigurationUpdate",
      parallelismConfigurationUpdate
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.FlinkApplicationConfigurationUpdate
  ) extends zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationUpdate.ReadOnly {
    override val checkpointConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationUpdate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.checkpointConfigurationUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationUpdate
          .wrap(value)
      )
    override val monitoringConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.MonitoringConfigurationUpdate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.monitoringConfigurationUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.MonitoringConfigurationUpdate
          .wrap(value)
      )
    override val parallelismConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.ParallelismConfigurationUpdate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.parallelismConfigurationUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.ParallelismConfigurationUpdate
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.FlinkApplicationConfigurationUpdate
  ): zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationUpdate.ReadOnly =
    new Wrapper(impl)
}
