package zio.aws.kinesisanalyticsv2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kinesisanalyticsv2.model.primitives.{
  BooleanObject,
  ParallelismPerKPU,
  Parallelism
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ParallelismConfigurationUpdate(
    configurationTypeUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.ConfigurationType
    ] = Optional.Absent,
    parallelismUpdate: Optional[Parallelism] = Optional.Absent,
    parallelismPerKPUUpdate: Optional[ParallelismPerKPU] = Optional.Absent,
    autoScalingEnabledUpdate: Optional[BooleanObject] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.ParallelismConfigurationUpdate = {
    import ParallelismConfigurationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ParallelismConfigurationUpdate
      .builder()
      .optionallyWith(configurationTypeUpdate.map(value => value.unwrap))(
        _.configurationTypeUpdate
      )
      .optionallyWith(
        parallelismUpdate.map(value => Parallelism.unwrap(value): Integer)
      )(_.parallelismUpdate)
      .optionallyWith(
        parallelismPerKPUUpdate.map(value =>
          ParallelismPerKPU.unwrap(value): Integer
        )
      )(_.parallelismPerKPUUpdate)
      .optionallyWith(
        autoScalingEnabledUpdate.map(value => value: java.lang.Boolean)
      )(_.autoScalingEnabledUpdate)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.ParallelismConfigurationUpdate.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.ParallelismConfigurationUpdate
      .wrap(buildAwsValue())
}
object ParallelismConfigurationUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ParallelismConfigurationUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.ParallelismConfigurationUpdate =
      zio.aws.kinesisanalyticsv2.model.ParallelismConfigurationUpdate(
        configurationTypeUpdate.map(value => value),
        parallelismUpdate.map(value => value),
        parallelismPerKPUUpdate.map(value => value),
        autoScalingEnabledUpdate.map(value => value)
      )
    def configurationTypeUpdate
        : Optional[zio.aws.kinesisanalyticsv2.model.ConfigurationType]
    def parallelismUpdate: Optional[Parallelism]
    def parallelismPerKPUUpdate: Optional[ParallelismPerKPU]
    def autoScalingEnabledUpdate: Optional[BooleanObject]
    def getConfigurationTypeUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ConfigurationType
    ] = AwsError.unwrapOptionField(
      "configurationTypeUpdate",
      configurationTypeUpdate
    )
    def getParallelismUpdate: ZIO[Any, AwsError, Parallelism] =
      AwsError.unwrapOptionField("parallelismUpdate", parallelismUpdate)
    def getParallelismPerKPUUpdate: ZIO[Any, AwsError, ParallelismPerKPU] =
      AwsError.unwrapOptionField(
        "parallelismPerKPUUpdate",
        parallelismPerKPUUpdate
      )
    def getAutoScalingEnabledUpdate: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField(
        "autoScalingEnabledUpdate",
        autoScalingEnabledUpdate
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ParallelismConfigurationUpdate
  ) extends zio.aws.kinesisanalyticsv2.model.ParallelismConfigurationUpdate.ReadOnly {
    override val configurationTypeUpdate
        : Optional[zio.aws.kinesisanalyticsv2.model.ConfigurationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationTypeUpdate())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.ConfigurationType.wrap(value)
        )
    override val parallelismUpdate: Optional[Parallelism] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parallelismUpdate())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.primitives.Parallelism(value)
        )
    override val parallelismPerKPUUpdate: Optional[ParallelismPerKPU] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parallelismPerKPUUpdate())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.primitives.ParallelismPerKPU(value)
        )
    override val autoScalingEnabledUpdate: Optional[BooleanObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoScalingEnabledUpdate())
        .map(value => value: BooleanObject)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ParallelismConfigurationUpdate
  ): zio.aws.kinesisanalyticsv2.model.ParallelismConfigurationUpdate.ReadOnly =
    new Wrapper(impl)
}
