package zio.aws.kinesisanalyticsv2.model
import scala.jdk.CollectionConverters.*
sealed trait RecordFormatType {
  def unwrap: software.amazon.awssdk.services.kinesisanalyticsv2.model.RecordFormatType
}
object RecordFormatType {
  def wrap(
      value: software.amazon.awssdk.services.kinesisanalyticsv2.model.RecordFormatType
  ): zio.aws.kinesisanalyticsv2.model.RecordFormatType = value match {
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.RecordFormatType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.RecordFormatType.JSON =>
      val r = JSON
      r
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.RecordFormatType.CSV =>
      val r = CSV
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kinesisanalyticsv2.model.RecordFormatType {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.RecordFormatType =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.RecordFormatType.UNKNOWN_TO_SDK_VERSION
  }
  case object JSON extends zio.aws.kinesisanalyticsv2.model.RecordFormatType {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.RecordFormatType =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.RecordFormatType.JSON
  }
  case object CSV extends zio.aws.kinesisanalyticsv2.model.RecordFormatType {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.RecordFormatType =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.RecordFormatType.CSV
  }
}
