package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  ApplicationVersionId,
  ResourceARN
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AddApplicationOutputResponse(
    applicationARN: Optional[ResourceARN] = Optional.Absent,
    applicationVersionId: Optional[ApplicationVersionId] = Optional.Absent,
    outputDescriptions: Optional[
      Iterable[zio.aws.kinesisanalyticsv2.model.OutputDescription]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationOutputResponse = {
    import AddApplicationOutputResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationOutputResponse
      .builder()
      .optionallyWith(
        applicationARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.applicationARN)
      .optionallyWith(
        applicationVersionId.map(value =>
          ApplicationVersionId.unwrap(value): java.lang.Long
        )
      )(_.applicationVersionId)
      .optionallyWith(
        outputDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputDescriptions)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.AddApplicationOutputResponse.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.AddApplicationOutputResponse
      .wrap(buildAwsValue())
}
object AddApplicationOutputResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationOutputResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.AddApplicationOutputResponse =
      zio.aws.kinesisanalyticsv2.model.AddApplicationOutputResponse(
        applicationARN.map(value => value),
        applicationVersionId.map(value => value),
        outputDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def applicationARN: Optional[ResourceARN]
    def applicationVersionId: Optional[ApplicationVersionId]
    def outputDescriptions: Optional[
      List[zio.aws.kinesisanalyticsv2.model.OutputDescription.ReadOnly]
    ]
    def getApplicationARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("applicationARN", applicationARN)
    def getApplicationVersionId: ZIO[Any, AwsError, ApplicationVersionId] =
      AwsError.unwrapOptionField("applicationVersionId", applicationVersionId)
    def getOutputDescriptions: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalyticsv2.model.OutputDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("outputDescriptions", outputDescriptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationOutputResponse
  ) extends zio.aws.kinesisanalyticsv2.model.AddApplicationOutputResponse.ReadOnly {
    override val applicationARN: Optional[ResourceARN] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationARN())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.ResourceARN(value)
      )
    override val applicationVersionId: Optional[ApplicationVersionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationVersionId())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.primitives
            .ApplicationVersionId(value)
        )
    override val outputDescriptions: Optional[
      List[zio.aws.kinesisanalyticsv2.model.OutputDescription.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.outputDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalyticsv2.model.OutputDescription.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationOutputResponse
  ): zio.aws.kinesisanalyticsv2.model.AddApplicationOutputResponse.ReadOnly =
    new Wrapper(impl)
}
