package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  Timestamp,
  SnapshotName,
  ApplicationName
}
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DeleteApplicationSnapshotRequest(
    applicationName: ApplicationName,
    snapshotName: SnapshotName,
    snapshotCreationTimestamp: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationSnapshotRequest = {
    import DeleteApplicationSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationSnapshotRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .snapshotName(SnapshotName.unwrap(snapshotName): java.lang.String)
      .snapshotCreationTimestamp(
        Timestamp.unwrap(snapshotCreationTimestamp): Instant
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.DeleteApplicationSnapshotRequest.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.DeleteApplicationSnapshotRequest
      .wrap(buildAwsValue())
}
object DeleteApplicationSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.DeleteApplicationSnapshotRequest =
      zio.aws.kinesisanalyticsv2.model.DeleteApplicationSnapshotRequest(
        applicationName,
        snapshotName,
        snapshotCreationTimestamp
      )
    def applicationName: ApplicationName
    def snapshotName: SnapshotName
    def snapshotCreationTimestamp: Timestamp
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getSnapshotName: ZIO[Any, Nothing, SnapshotName] =
      ZIO.succeed(snapshotName)
    def getSnapshotCreationTimestamp: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(snapshotCreationTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationSnapshotRequest
  ) extends zio.aws.kinesisanalyticsv2.model.DeleteApplicationSnapshotRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationName(impl.applicationName())
    override val snapshotName: SnapshotName =
      zio.aws.kinesisanalyticsv2.model.primitives
        .SnapshotName(impl.snapshotName())
    override val snapshotCreationTimestamp: Timestamp =
      zio.aws.kinesisanalyticsv2.model.primitives
        .Timestamp(impl.snapshotCreationTimestamp())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationSnapshotRequest
  ): zio.aws.kinesisanalyticsv2.model.DeleteApplicationSnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
