package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  ApplicationVersionId,
  ResourceARN
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AddApplicationReferenceDataSourceResponse(
    applicationARN: Optional[ResourceARN] = Optional.Absent,
    applicationVersionId: Optional[ApplicationVersionId] = Optional.Absent,
    referenceDataSourceDescriptions: Optional[
      Iterable[zio.aws.kinesisanalyticsv2.model.ReferenceDataSourceDescription]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceResponse = {
    import AddApplicationReferenceDataSourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceResponse
      .builder()
      .optionallyWith(
        applicationARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.applicationARN)
      .optionallyWith(
        applicationVersionId.map(value =>
          ApplicationVersionId.unwrap(value): java.lang.Long
        )
      )(_.applicationVersionId)
      .optionallyWith(
        referenceDataSourceDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.referenceDataSourceDescriptions)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceResponse.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceResponse
      .wrap(buildAwsValue())
}
object AddApplicationReferenceDataSourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceResponse =
      zio.aws.kinesisanalyticsv2.model
        .AddApplicationReferenceDataSourceResponse(
          applicationARN.map(value => value),
          applicationVersionId.map(value => value),
          referenceDataSourceDescriptions.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def applicationARN: Optional[ResourceARN]
    def applicationVersionId: Optional[ApplicationVersionId]
    def referenceDataSourceDescriptions: Optional[List[
      zio.aws.kinesisanalyticsv2.model.ReferenceDataSourceDescription.ReadOnly
    ]]
    def getApplicationARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("applicationARN", applicationARN)
    def getApplicationVersionId: ZIO[Any, AwsError, ApplicationVersionId] =
      AwsError.unwrapOptionField("applicationVersionId", applicationVersionId)
    def getReferenceDataSourceDescriptions: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalyticsv2.model.ReferenceDataSourceDescription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "referenceDataSourceDescriptions",
      referenceDataSourceDescriptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceResponse
  ) extends zio.aws.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceResponse.ReadOnly {
    override val applicationARN: Optional[ResourceARN] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationARN())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.ResourceARN(value)
      )
    override val applicationVersionId: Optional[ApplicationVersionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationVersionId())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.primitives
            .ApplicationVersionId(value)
        )
    override val referenceDataSourceDescriptions: Optional[List[
      zio.aws.kinesisanalyticsv2.model.ReferenceDataSourceDescription.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.referenceDataSourceDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalyticsv2.model.ReferenceDataSourceDescription
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceResponse
  ): zio.aws.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceResponse.ReadOnly =
    new Wrapper(impl)
}
