package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  ApplicationVersionId,
  ApplicationName
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AddApplicationReferenceDataSourceRequest(
    applicationName: ApplicationName,
    currentApplicationVersionId: ApplicationVersionId,
    referenceDataSource: zio.aws.kinesisanalyticsv2.model.ReferenceDataSource
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceRequest = {
    import AddApplicationReferenceDataSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .currentApplicationVersionId(
        ApplicationVersionId.unwrap(currentApplicationVersionId): java.lang.Long
      )
      .referenceDataSource(referenceDataSource.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceRequest.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceRequest
      .wrap(buildAwsValue())
}
object AddApplicationReferenceDataSourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceRequest =
      zio.aws.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceRequest(
        applicationName,
        currentApplicationVersionId,
        referenceDataSource.asEditable
      )
    def applicationName: ApplicationName
    def currentApplicationVersionId: ApplicationVersionId
    def referenceDataSource
        : zio.aws.kinesisanalyticsv2.model.ReferenceDataSource.ReadOnly
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getCurrentApplicationVersionId
        : ZIO[Any, Nothing, ApplicationVersionId] =
      ZIO.succeed(currentApplicationVersionId)
    def getReferenceDataSource: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalyticsv2.model.ReferenceDataSource.ReadOnly
    ] = ZIO.succeed(referenceDataSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceRequest
  ) extends zio.aws.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationName(impl.applicationName())
    override val currentApplicationVersionId: ApplicationVersionId =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationVersionId(impl.currentApplicationVersionId())
    override val referenceDataSource
        : zio.aws.kinesisanalyticsv2.model.ReferenceDataSource.ReadOnly =
      zio.aws.kinesisanalyticsv2.model.ReferenceDataSource
        .wrap(impl.referenceDataSource())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceRequest
  ): zio.aws.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceRequest.ReadOnly =
    new Wrapper(impl)
}
