package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{RoleARN, LogStreamARN, Id}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CloudWatchLoggingOptionDescription(
    cloudWatchLoggingOptionId: Optional[Id] = Optional.Absent,
    logStreamARN: LogStreamARN,
    roleARN: Optional[RoleARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.CloudWatchLoggingOptionDescription = {
    import CloudWatchLoggingOptionDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CloudWatchLoggingOptionDescription
      .builder()
      .optionallyWith(
        cloudWatchLoggingOptionId.map(value =>
          Id.unwrap(value): java.lang.String
        )
      )(_.cloudWatchLoggingOptionId)
      .logStreamARN(LogStreamARN.unwrap(logStreamARN): java.lang.String)
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionDescription.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionDescription
      .wrap(buildAwsValue())
}
object CloudWatchLoggingOptionDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CloudWatchLoggingOptionDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionDescription =
      zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionDescription(
        cloudWatchLoggingOptionId.map(value => value),
        logStreamARN,
        roleARN.map(value => value)
      )
    def cloudWatchLoggingOptionId: Optional[Id]
    def logStreamARN: LogStreamARN
    def roleARN: Optional[RoleARN]
    def getCloudWatchLoggingOptionId: ZIO[Any, AwsError, Id] = AwsError
      .unwrapOptionField("cloudWatchLoggingOptionId", cloudWatchLoggingOptionId)
    def getLogStreamARN: ZIO[Any, Nothing, LogStreamARN] =
      ZIO.succeed(logStreamARN)
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CloudWatchLoggingOptionDescription
  ) extends zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionDescription.ReadOnly {
    override val cloudWatchLoggingOptionId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudWatchLoggingOptionId())
      .map(value => zio.aws.kinesisanalyticsv2.model.primitives.Id(value))
    override val logStreamARN: LogStreamARN =
      zio.aws.kinesisanalyticsv2.model.primitives
        .LogStreamARN(impl.logStreamARN())
    override val roleARN: Optional[RoleARN] = zio.aws.core.internal
      .optionalFromNullable(impl.roleARN())
      .map(value => zio.aws.kinesisanalyticsv2.model.primitives.RoleARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CloudWatchLoggingOptionDescription
  ): zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionDescription.ReadOnly =
    new Wrapper(impl)
}
