package zio.aws.kinesisanalyticsv2.model
import scala.jdk.CollectionConverters.*
sealed trait UrlType {
  def unwrap: software.amazon.awssdk.services.kinesisanalyticsv2.model.UrlType
}
object UrlType {
  def wrap(
      value: software.amazon.awssdk.services.kinesisanalyticsv2.model.UrlType
  ): zio.aws.kinesisanalyticsv2.model.UrlType = value match {
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.UrlType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.UrlType.FLINK_DASHBOARD_URL =>
      val r = FLINK_DASHBOARD_URL
      r
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.UrlType.ZEPPELIN_UI_URL =>
      val r = ZEPPELIN_UI_URL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kinesisanalyticsv2.model.UrlType {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.UrlType =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.UrlType.UNKNOWN_TO_SDK_VERSION
  }
  case object FLINK_DASHBOARD_URL
      extends zio.aws.kinesisanalyticsv2.model.UrlType {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.UrlType =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.UrlType.FLINK_DASHBOARD_URL
  }
  case object ZEPPELIN_UI_URL extends zio.aws.kinesisanalyticsv2.model.UrlType {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.UrlType =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.UrlType.ZEPPELIN_UI_URL
  }
}
