package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListApplicationVersionsResponse(
    applicationVersionSummaries: Optional[
      Iterable[zio.aws.kinesisanalyticsv2.model.ApplicationVersionSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationVersionsResponse = {
    import ListApplicationVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationVersionsResponse
      .builder()
      .optionallyWith(
        applicationVersionSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.applicationVersionSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.ListApplicationVersionsResponse.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.ListApplicationVersionsResponse
      .wrap(buildAwsValue())
}
object ListApplicationVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.ListApplicationVersionsResponse =
      zio.aws.kinesisanalyticsv2.model.ListApplicationVersionsResponse(
        applicationVersionSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def applicationVersionSummaries: Optional[
      List[zio.aws.kinesisanalyticsv2.model.ApplicationVersionSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getApplicationVersionSummaries: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalyticsv2.model.ApplicationVersionSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "applicationVersionSummaries",
      applicationVersionSummaries
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationVersionsResponse
  ) extends zio.aws.kinesisanalyticsv2.model.ListApplicationVersionsResponse.ReadOnly {
    override val applicationVersionSummaries: Optional[
      List[zio.aws.kinesisanalyticsv2.model.ApplicationVersionSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationVersionSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalyticsv2.model.ApplicationVersionSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationVersionsResponse
  ): zio.aws.kinesisanalyticsv2.model.ListApplicationVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
