package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SqlApplicationConfigurationUpdate(
    inputUpdates: Optional[
      Iterable[zio.aws.kinesisanalyticsv2.model.InputUpdate]
    ] = Optional.Absent,
    outputUpdates: Optional[
      Iterable[zio.aws.kinesisanalyticsv2.model.OutputUpdate]
    ] = Optional.Absent,
    referenceDataSourceUpdates: Optional[
      Iterable[zio.aws.kinesisanalyticsv2.model.ReferenceDataSourceUpdate]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.SqlApplicationConfigurationUpdate = {
    import SqlApplicationConfigurationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.SqlApplicationConfigurationUpdate
      .builder()
      .optionallyWith(
        inputUpdates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputUpdates)
      .optionallyWith(
        outputUpdates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputUpdates)
      .optionallyWith(
        referenceDataSourceUpdates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.referenceDataSourceUpdates)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.SqlApplicationConfigurationUpdate.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.SqlApplicationConfigurationUpdate
      .wrap(buildAwsValue())
}
object SqlApplicationConfigurationUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.SqlApplicationConfigurationUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.SqlApplicationConfigurationUpdate =
      zio.aws.kinesisanalyticsv2.model.SqlApplicationConfigurationUpdate(
        inputUpdates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        outputUpdates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        referenceDataSourceUpdates.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def inputUpdates
        : Optional[List[zio.aws.kinesisanalyticsv2.model.InputUpdate.ReadOnly]]
    def outputUpdates
        : Optional[List[zio.aws.kinesisanalyticsv2.model.OutputUpdate.ReadOnly]]
    def referenceDataSourceUpdates: Optional[
      List[zio.aws.kinesisanalyticsv2.model.ReferenceDataSourceUpdate.ReadOnly]
    ]
    def getInputUpdates: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalyticsv2.model.InputUpdate.ReadOnly
    ]] = AwsError.unwrapOptionField("inputUpdates", inputUpdates)
    def getOutputUpdates: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalyticsv2.model.OutputUpdate.ReadOnly
    ]] = AwsError.unwrapOptionField("outputUpdates", outputUpdates)
    def getReferenceDataSourceUpdates: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalyticsv2.model.ReferenceDataSourceUpdate.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "referenceDataSourceUpdates",
      referenceDataSourceUpdates
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.SqlApplicationConfigurationUpdate
  ) extends zio.aws.kinesisanalyticsv2.model.SqlApplicationConfigurationUpdate.ReadOnly {
    override val inputUpdates: Optional[
      List[zio.aws.kinesisanalyticsv2.model.InputUpdate.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.inputUpdates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalyticsv2.model.InputUpdate.wrap(item)
        }.toList
      )
    override val outputUpdates: Optional[
      List[zio.aws.kinesisanalyticsv2.model.OutputUpdate.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.outputUpdates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalyticsv2.model.OutputUpdate.wrap(item)
        }.toList
      )
    override val referenceDataSourceUpdates: Optional[
      List[zio.aws.kinesisanalyticsv2.model.ReferenceDataSourceUpdate.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.referenceDataSourceUpdates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalyticsv2.model.ReferenceDataSourceUpdate.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.SqlApplicationConfigurationUpdate
  ): zio.aws.kinesisanalyticsv2.model.SqlApplicationConfigurationUpdate.ReadOnly =
    new Wrapper(impl)
}
