package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.InAppTableName
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ReferenceDataSource(
    tableName: InAppTableName,
    s3ReferenceDataSource: Optional[
      zio.aws.kinesisanalyticsv2.model.S3ReferenceDataSource
    ] = Optional.Absent,
    referenceSchema: zio.aws.kinesisanalyticsv2.model.SourceSchema
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.ReferenceDataSource = {
    import ReferenceDataSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ReferenceDataSource
      .builder()
      .tableName(InAppTableName.unwrap(tableName): java.lang.String)
      .optionallyWith(
        s3ReferenceDataSource.map(value => value.buildAwsValue())
      )(_.s3ReferenceDataSource)
      .referenceSchema(referenceSchema.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.ReferenceDataSource.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.ReferenceDataSource.wrap(buildAwsValue())
}
object ReferenceDataSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ReferenceDataSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.ReferenceDataSource =
      zio.aws.kinesisanalyticsv2.model.ReferenceDataSource(
        tableName,
        s3ReferenceDataSource.map(value => value.asEditable),
        referenceSchema.asEditable
      )
    def tableName: InAppTableName
    def s3ReferenceDataSource: Optional[
      zio.aws.kinesisanalyticsv2.model.S3ReferenceDataSource.ReadOnly
    ]
    def referenceSchema: zio.aws.kinesisanalyticsv2.model.SourceSchema.ReadOnly
    def getTableName: ZIO[Any, Nothing, InAppTableName] = ZIO.succeed(tableName)
    def getS3ReferenceDataSource: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.S3ReferenceDataSource.ReadOnly
    ] =
      AwsError.unwrapOptionField("s3ReferenceDataSource", s3ReferenceDataSource)
    def getReferenceSchema: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalyticsv2.model.SourceSchema.ReadOnly
    ] = ZIO.succeed(referenceSchema)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ReferenceDataSource
  ) extends zio.aws.kinesisanalyticsv2.model.ReferenceDataSource.ReadOnly {
    override val tableName: InAppTableName =
      zio.aws.kinesisanalyticsv2.model.primitives
        .InAppTableName(impl.tableName())
    override val s3ReferenceDataSource: Optional[
      zio.aws.kinesisanalyticsv2.model.S3ReferenceDataSource.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.s3ReferenceDataSource())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.S3ReferenceDataSource.wrap(value)
      )
    override val referenceSchema
        : zio.aws.kinesisanalyticsv2.model.SourceSchema.ReadOnly =
      zio.aws.kinesisanalyticsv2.model.SourceSchema.wrap(impl.referenceSchema())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ReferenceDataSource
  ): zio.aws.kinesisanalyticsv2.model.ReferenceDataSource.ReadOnly =
    new Wrapper(impl)
}
