package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ZeppelinApplicationConfiguration(
    monitoringConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.ZeppelinMonitoringConfiguration
    ] = Optional.Absent,
    catalogConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.CatalogConfiguration
    ] = Optional.Absent,
    deployAsApplicationConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.DeployAsApplicationConfiguration
    ] = Optional.Absent,
    customArtifactsConfiguration: Optional[
      Iterable[zio.aws.kinesisanalyticsv2.model.CustomArtifactConfiguration]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.ZeppelinApplicationConfiguration = {
    import ZeppelinApplicationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ZeppelinApplicationConfiguration
      .builder()
      .optionallyWith(
        monitoringConfiguration.map(value => value.buildAwsValue())
      )(_.monitoringConfiguration)
      .optionallyWith(catalogConfiguration.map(value => value.buildAwsValue()))(
        _.catalogConfiguration
      )
      .optionallyWith(
        deployAsApplicationConfiguration.map(value => value.buildAwsValue())
      )(_.deployAsApplicationConfiguration)
      .optionallyWith(
        customArtifactsConfiguration.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customArtifactsConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfiguration.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfiguration
      .wrap(buildAwsValue())
}
object ZeppelinApplicationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ZeppelinApplicationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfiguration =
      zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfiguration(
        monitoringConfiguration.map(value => value.asEditable),
        catalogConfiguration.map(value => value.asEditable),
        deployAsApplicationConfiguration.map(value => value.asEditable),
        customArtifactsConfiguration.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def monitoringConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.ZeppelinMonitoringConfiguration.ReadOnly
    ]
    def catalogConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.CatalogConfiguration.ReadOnly
    ]
    def deployAsApplicationConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.DeployAsApplicationConfiguration.ReadOnly
    ]
    def customArtifactsConfiguration: Optional[List[
      zio.aws.kinesisanalyticsv2.model.CustomArtifactConfiguration.ReadOnly
    ]]
    def getMonitoringConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ZeppelinMonitoringConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "monitoringConfiguration",
      monitoringConfiguration
    )
    def getCatalogConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.CatalogConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("catalogConfiguration", catalogConfiguration)
    def getDeployAsApplicationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.DeployAsApplicationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "deployAsApplicationConfiguration",
      deployAsApplicationConfiguration
    )
    def getCustomArtifactsConfiguration: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalyticsv2.model.CustomArtifactConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "customArtifactsConfiguration",
      customArtifactsConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ZeppelinApplicationConfiguration
  ) extends zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfiguration.ReadOnly {
    override val monitoringConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.ZeppelinMonitoringConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.monitoringConfiguration())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.ZeppelinMonitoringConfiguration
          .wrap(value)
      )
    override val catalogConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.CatalogConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.catalogConfiguration())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.CatalogConfiguration.wrap(value)
      )
    override val deployAsApplicationConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.DeployAsApplicationConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deployAsApplicationConfiguration())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.DeployAsApplicationConfiguration
          .wrap(value)
      )
    override val customArtifactsConfiguration: Optional[List[
      zio.aws.kinesisanalyticsv2.model.CustomArtifactConfiguration.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.customArtifactsConfiguration())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalyticsv2.model.CustomArtifactConfiguration
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ZeppelinApplicationConfiguration
  ): zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfiguration.ReadOnly =
    new Wrapper(impl)
}
