package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MappingParameters(
    jsonMappingParameters: Optional[
      zio.aws.kinesisanalyticsv2.model.JSONMappingParameters
    ] = Optional.Absent,
    csvMappingParameters: Optional[
      zio.aws.kinesisanalyticsv2.model.CSVMappingParameters
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.MappingParameters = {
    import MappingParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.MappingParameters
      .builder()
      .optionallyWith(
        jsonMappingParameters.map(value => value.buildAwsValue())
      )(_.jsonMappingParameters)
      .optionallyWith(csvMappingParameters.map(value => value.buildAwsValue()))(
        _.csvMappingParameters
      )
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalyticsv2.model.MappingParameters.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.MappingParameters.wrap(buildAwsValue())
}
object MappingParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.MappingParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.MappingParameters =
      zio.aws.kinesisanalyticsv2.model.MappingParameters(
        jsonMappingParameters.map(value => value.asEditable),
        csvMappingParameters.map(value => value.asEditable)
      )
    def jsonMappingParameters: Optional[
      zio.aws.kinesisanalyticsv2.model.JSONMappingParameters.ReadOnly
    ]
    def csvMappingParameters: Optional[
      zio.aws.kinesisanalyticsv2.model.CSVMappingParameters.ReadOnly
    ]
    def getJsonMappingParameters: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.JSONMappingParameters.ReadOnly
    ] =
      AwsError.unwrapOptionField("jsonMappingParameters", jsonMappingParameters)
    def getCsvMappingParameters: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.CSVMappingParameters.ReadOnly
    ] = AwsError.unwrapOptionField("csvMappingParameters", csvMappingParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.MappingParameters
  ) extends zio.aws.kinesisanalyticsv2.model.MappingParameters.ReadOnly {
    override val jsonMappingParameters: Optional[
      zio.aws.kinesisanalyticsv2.model.JSONMappingParameters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.jsonMappingParameters())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.JSONMappingParameters.wrap(value)
      )
    override val csvMappingParameters: Optional[
      zio.aws.kinesisanalyticsv2.model.CSVMappingParameters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.csvMappingParameters())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.CSVMappingParameters.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.MappingParameters
  ): zio.aws.kinesisanalyticsv2.model.MappingParameters.ReadOnly = new Wrapper(
    impl
  )
}
