package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{FileKey, BucketARN}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class S3Configuration(bucketARN: BucketARN, fileKey: FileKey) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.S3Configuration = {
    import S3Configuration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.S3Configuration
      .builder()
      .bucketARN(BucketARN.unwrap(bucketARN): java.lang.String)
      .fileKey(FileKey.unwrap(fileKey): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalyticsv2.model.S3Configuration.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.S3Configuration.wrap(buildAwsValue())
}
object S3Configuration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.S3Configuration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.S3Configuration =
      zio.aws.kinesisanalyticsv2.model.S3Configuration(bucketARN, fileKey)
    def bucketARN: BucketARN
    def fileKey: FileKey
    def getBucketARN: ZIO[Any, Nothing, BucketARN] = ZIO.succeed(bucketARN)
    def getFileKey: ZIO[Any, Nothing, FileKey] = ZIO.succeed(fileKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.S3Configuration
  ) extends zio.aws.kinesisanalyticsv2.model.S3Configuration.ReadOnly {
    override val bucketARN: BucketARN =
      zio.aws.kinesisanalyticsv2.model.primitives.BucketARN(impl.bucketARN())
    override val fileKey: FileKey =
      zio.aws.kinesisanalyticsv2.model.primitives.FileKey(impl.fileKey())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.S3Configuration
  ): zio.aws.kinesisanalyticsv2.model.S3Configuration.ReadOnly = new Wrapper(
    impl
  )
}
