package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.KinesisAnalyticsARN
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceARN: KinesisAnalyticsARN,
    tags: Iterable[zio.aws.kinesisanalyticsv2.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.TagResourceRequest
      .builder()
      .resourceARN(KinesisAnalyticsARN.unwrap(resourceARN): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalyticsv2.model.TagResourceRequest.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.TagResourceRequest =
      zio.aws.kinesisanalyticsv2.model.TagResourceRequest(
        resourceARN,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceARN: KinesisAnalyticsARN
    def tags: List[zio.aws.kinesisanalyticsv2.model.Tag.ReadOnly]
    def getResourceARN: ZIO[Any, Nothing, KinesisAnalyticsARN] =
      ZIO.succeed(resourceARN)
    def getTags: ZIO[Any, Nothing, List[
      zio.aws.kinesisanalyticsv2.model.Tag.ReadOnly
    ]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.TagResourceRequest
  ) extends zio.aws.kinesisanalyticsv2.model.TagResourceRequest.ReadOnly {
    override val resourceARN: KinesisAnalyticsARN =
      zio.aws.kinesisanalyticsv2.model.primitives
        .KinesisAnalyticsARN(impl.resourceARN())
    override val tags: List[zio.aws.kinesisanalyticsv2.model.Tag.ReadOnly] =
      impl
        .tags()
        .asScala
        .map { item =>
          zio.aws.kinesisanalyticsv2.model.Tag.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.TagResourceRequest
  ): zio.aws.kinesisanalyticsv2.model.TagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
