package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ApplicationConfigurationUpdate(
    sqlApplicationConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.SqlApplicationConfigurationUpdate
    ] = Optional.Absent,
    applicationCodeConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfigurationUpdate
    ] = Optional.Absent,
    flinkApplicationConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationUpdate
    ] = Optional.Absent,
    environmentPropertyUpdates: Optional[
      zio.aws.kinesisanalyticsv2.model.EnvironmentPropertyUpdates
    ] = Optional.Absent,
    applicationSnapshotConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.ApplicationSnapshotConfigurationUpdate
    ] = Optional.Absent,
    vpcConfigurationUpdates: Optional[
      Iterable[zio.aws.kinesisanalyticsv2.model.VpcConfigurationUpdate]
    ] = Optional.Absent,
    zeppelinApplicationConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationUpdate
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationConfigurationUpdate = {
    import ApplicationConfigurationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationConfigurationUpdate
      .builder()
      .optionallyWith(
        sqlApplicationConfigurationUpdate.map(value => value.buildAwsValue())
      )(_.sqlApplicationConfigurationUpdate)
      .optionallyWith(
        applicationCodeConfigurationUpdate.map(value => value.buildAwsValue())
      )(_.applicationCodeConfigurationUpdate)
      .optionallyWith(
        flinkApplicationConfigurationUpdate.map(value => value.buildAwsValue())
      )(_.flinkApplicationConfigurationUpdate)
      .optionallyWith(
        environmentPropertyUpdates.map(value => value.buildAwsValue())
      )(_.environmentPropertyUpdates)
      .optionallyWith(
        applicationSnapshotConfigurationUpdate.map(value =>
          value.buildAwsValue()
        )
      )(_.applicationSnapshotConfigurationUpdate)
      .optionallyWith(
        vpcConfigurationUpdates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcConfigurationUpdates)
      .optionallyWith(
        zeppelinApplicationConfigurationUpdate.map(value =>
          value.buildAwsValue()
        )
      )(_.zeppelinApplicationConfigurationUpdate)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.ApplicationConfigurationUpdate.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.ApplicationConfigurationUpdate
      .wrap(buildAwsValue())
}
object ApplicationConfigurationUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationConfigurationUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.ApplicationConfigurationUpdate =
      zio.aws.kinesisanalyticsv2.model.ApplicationConfigurationUpdate(
        sqlApplicationConfigurationUpdate.map(value => value.asEditable),
        applicationCodeConfigurationUpdate.map(value => value.asEditable),
        flinkApplicationConfigurationUpdate.map(value => value.asEditable),
        environmentPropertyUpdates.map(value => value.asEditable),
        applicationSnapshotConfigurationUpdate.map(value => value.asEditable),
        vpcConfigurationUpdates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        zeppelinApplicationConfigurationUpdate.map(value => value.asEditable)
      )
    def sqlApplicationConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.SqlApplicationConfigurationUpdate.ReadOnly
    ]
    def applicationCodeConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfigurationUpdate.ReadOnly
    ]
    def flinkApplicationConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationUpdate.ReadOnly
    ]
    def environmentPropertyUpdates: Optional[
      zio.aws.kinesisanalyticsv2.model.EnvironmentPropertyUpdates.ReadOnly
    ]
    def applicationSnapshotConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.ApplicationSnapshotConfigurationUpdate.ReadOnly
    ]
    def vpcConfigurationUpdates: Optional[
      List[zio.aws.kinesisanalyticsv2.model.VpcConfigurationUpdate.ReadOnly]
    ]
    def zeppelinApplicationConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationUpdate.ReadOnly
    ]
    def getSqlApplicationConfigurationUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.SqlApplicationConfigurationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sqlApplicationConfigurationUpdate",
      sqlApplicationConfigurationUpdate
    )
    def getApplicationCodeConfigurationUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfigurationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "applicationCodeConfigurationUpdate",
      applicationCodeConfigurationUpdate
    )
    def getFlinkApplicationConfigurationUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "flinkApplicationConfigurationUpdate",
      flinkApplicationConfigurationUpdate
    )
    def getEnvironmentPropertyUpdates: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.EnvironmentPropertyUpdates.ReadOnly
    ] = AwsError.unwrapOptionField(
      "environmentPropertyUpdates",
      environmentPropertyUpdates
    )
    def getApplicationSnapshotConfigurationUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ApplicationSnapshotConfigurationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "applicationSnapshotConfigurationUpdate",
      applicationSnapshotConfigurationUpdate
    )
    def getVpcConfigurationUpdates: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalyticsv2.model.VpcConfigurationUpdate.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "vpcConfigurationUpdates",
      vpcConfigurationUpdates
    )
    def getZeppelinApplicationConfigurationUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "zeppelinApplicationConfigurationUpdate",
      zeppelinApplicationConfigurationUpdate
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationConfigurationUpdate
  ) extends zio.aws.kinesisanalyticsv2.model.ApplicationConfigurationUpdate.ReadOnly {
    override val sqlApplicationConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.SqlApplicationConfigurationUpdate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sqlApplicationConfigurationUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.SqlApplicationConfigurationUpdate
          .wrap(value)
      )
    override val applicationCodeConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfigurationUpdate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationCodeConfigurationUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfigurationUpdate
          .wrap(value)
      )
    override val flinkApplicationConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationUpdate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.flinkApplicationConfigurationUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationUpdate
          .wrap(value)
      )
    override val environmentPropertyUpdates: Optional[
      zio.aws.kinesisanalyticsv2.model.EnvironmentPropertyUpdates.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentPropertyUpdates())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.EnvironmentPropertyUpdates.wrap(value)
      )
    override val applicationSnapshotConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.ApplicationSnapshotConfigurationUpdate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationSnapshotConfigurationUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.ApplicationSnapshotConfigurationUpdate
          .wrap(value)
      )
    override val vpcConfigurationUpdates: Optional[
      List[zio.aws.kinesisanalyticsv2.model.VpcConfigurationUpdate.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcConfigurationUpdates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalyticsv2.model.VpcConfigurationUpdate.wrap(item)
        }.toList
      )
    override val zeppelinApplicationConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationUpdate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.zeppelinApplicationConfigurationUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationUpdate
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationConfigurationUpdate
  ): zio.aws.kinesisanalyticsv2.model.ApplicationConfigurationUpdate.ReadOnly =
    new Wrapper(impl)
}
