package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{RoleARN, ResourceARN}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class KinesisFirehoseInputDescription(
    resourceARN: ResourceARN,
    roleARN: Optional[RoleARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisFirehoseInputDescription = {
    import KinesisFirehoseInputDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisFirehoseInputDescription
      .builder()
      .resourceARN(ResourceARN.unwrap(resourceARN): java.lang.String)
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.KinesisFirehoseInputDescription.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.KinesisFirehoseInputDescription
      .wrap(buildAwsValue())
}
object KinesisFirehoseInputDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisFirehoseInputDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.KinesisFirehoseInputDescription =
      zio.aws.kinesisanalyticsv2.model.KinesisFirehoseInputDescription(
        resourceARN,
        roleARN.map(value => value)
      )
    def resourceARN: ResourceARN
    def roleARN: Optional[RoleARN]
    def getResourceARN: ZIO[Any, Nothing, ResourceARN] =
      ZIO.succeed(resourceARN)
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisFirehoseInputDescription
  ) extends zio.aws.kinesisanalyticsv2.model.KinesisFirehoseInputDescription.ReadOnly {
    override val resourceARN: ResourceARN =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ResourceARN(impl.resourceARN())
    override val roleARN: Optional[RoleARN] = zio.aws.core.internal
      .optionalFromNullable(impl.roleARN())
      .map(value => zio.aws.kinesisanalyticsv2.model.primitives.RoleARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisFirehoseInputDescription
  ): zio.aws.kinesisanalyticsv2.model.KinesisFirehoseInputDescription.ReadOnly =
    new Wrapper(impl)
}
