package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{RoleARN, ResourceARN}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DiscoverInputSchemaRequest(
    resourceARN: Optional[ResourceARN] = Optional.Absent,
    serviceExecutionRole: RoleARN,
    inputStartingPositionConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.InputStartingPositionConfiguration
    ] = Optional.Absent,
    s3Configuration: Optional[
      zio.aws.kinesisanalyticsv2.model.S3Configuration
    ] = Optional.Absent,
    inputProcessingConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.InputProcessingConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.DiscoverInputSchemaRequest = {
    import DiscoverInputSchemaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.DiscoverInputSchemaRequest
      .builder()
      .optionallyWith(
        resourceARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.resourceARN)
      .serviceExecutionRole(
        RoleARN.unwrap(serviceExecutionRole): java.lang.String
      )
      .optionallyWith(
        inputStartingPositionConfiguration.map(value => value.buildAwsValue())
      )(_.inputStartingPositionConfiguration)
      .optionallyWith(s3Configuration.map(value => value.buildAwsValue()))(
        _.s3Configuration
      )
      .optionallyWith(
        inputProcessingConfiguration.map(value => value.buildAwsValue())
      )(_.inputProcessingConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.DiscoverInputSchemaRequest.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.DiscoverInputSchemaRequest
      .wrap(buildAwsValue())
}
object DiscoverInputSchemaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.DiscoverInputSchemaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.DiscoverInputSchemaRequest =
      zio.aws.kinesisanalyticsv2.model.DiscoverInputSchemaRequest(
        resourceARN.map(value => value),
        serviceExecutionRole,
        inputStartingPositionConfiguration.map(value => value.asEditable),
        s3Configuration.map(value => value.asEditable),
        inputProcessingConfiguration.map(value => value.asEditable)
      )
    def resourceARN: Optional[ResourceARN]
    def serviceExecutionRole: RoleARN
    def inputStartingPositionConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.InputStartingPositionConfiguration.ReadOnly
    ]
    def s3Configuration
        : Optional[zio.aws.kinesisanalyticsv2.model.S3Configuration.ReadOnly]
    def inputProcessingConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.InputProcessingConfiguration.ReadOnly
    ]
    def getResourceARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("resourceARN", resourceARN)
    def getServiceExecutionRole: ZIO[Any, Nothing, RoleARN] =
      ZIO.succeed(serviceExecutionRole)
    def getInputStartingPositionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.InputStartingPositionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inputStartingPositionConfiguration",
      inputStartingPositionConfiguration
    )
    def getS3Configuration: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.S3Configuration.ReadOnly
    ] = AwsError.unwrapOptionField("s3Configuration", s3Configuration)
    def getInputProcessingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.InputProcessingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inputProcessingConfiguration",
      inputProcessingConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.DiscoverInputSchemaRequest
  ) extends zio.aws.kinesisanalyticsv2.model.DiscoverInputSchemaRequest.ReadOnly {
    override val resourceARN: Optional[ResourceARN] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceARN())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.ResourceARN(value)
      )
    override val serviceExecutionRole: RoleARN =
      zio.aws.kinesisanalyticsv2.model.primitives
        .RoleARN(impl.serviceExecutionRole())
    override val inputStartingPositionConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.InputStartingPositionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.inputStartingPositionConfiguration())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.InputStartingPositionConfiguration
          .wrap(value)
      )
    override val s3Configuration
        : Optional[zio.aws.kinesisanalyticsv2.model.S3Configuration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Configuration())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.S3Configuration.wrap(value)
        )
    override val inputProcessingConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.InputProcessingConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.inputProcessingConfiguration())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.InputProcessingConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.DiscoverInputSchemaRequest
  ): zio.aws.kinesisanalyticsv2.model.DiscoverInputSchemaRequest.ReadOnly =
    new Wrapper(impl)
}
