package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  MavenVersion,
  MavenArtifactId,
  MavenGroupId
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class MavenReference(
    groupId: MavenGroupId,
    artifactId: MavenArtifactId,
    version: MavenVersion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.MavenReference = {
    import MavenReference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.MavenReference
      .builder()
      .groupId(MavenGroupId.unwrap(groupId): java.lang.String)
      .artifactId(MavenArtifactId.unwrap(artifactId): java.lang.String)
      .version(MavenVersion.unwrap(version): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalyticsv2.model.MavenReference.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.MavenReference.wrap(buildAwsValue())
}
object MavenReference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.MavenReference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.MavenReference =
      zio.aws.kinesisanalyticsv2.model
        .MavenReference(groupId, artifactId, version)
    def groupId: MavenGroupId
    def artifactId: MavenArtifactId
    def version: MavenVersion
    def getGroupId: ZIO[Any, Nothing, MavenGroupId] = ZIO.succeed(groupId)
    def getArtifactId: ZIO[Any, Nothing, MavenArtifactId] =
      ZIO.succeed(artifactId)
    def getVersion: ZIO[Any, Nothing, MavenVersion] = ZIO.succeed(version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.MavenReference
  ) extends zio.aws.kinesisanalyticsv2.model.MavenReference.ReadOnly {
    override val groupId: MavenGroupId =
      zio.aws.kinesisanalyticsv2.model.primitives.MavenGroupId(impl.groupId())
    override val artifactId: MavenArtifactId =
      zio.aws.kinesisanalyticsv2.model.primitives
        .MavenArtifactId(impl.artifactId())
    override val version: MavenVersion =
      zio.aws.kinesisanalyticsv2.model.primitives.MavenVersion(impl.version())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.MavenReference
  ): zio.aws.kinesisanalyticsv2.model.MavenReference.ReadOnly = new Wrapper(
    impl
  )
}
