package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  ApplicationVersionId,
  ApplicationName
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RollbackApplicationRequest(
    applicationName: ApplicationName,
    currentApplicationVersionId: ApplicationVersionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.RollbackApplicationRequest = {
    import RollbackApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.RollbackApplicationRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .currentApplicationVersionId(
        ApplicationVersionId.unwrap(currentApplicationVersionId): java.lang.Long
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.RollbackApplicationRequest.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.RollbackApplicationRequest
      .wrap(buildAwsValue())
}
object RollbackApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.RollbackApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.RollbackApplicationRequest =
      zio.aws.kinesisanalyticsv2.model.RollbackApplicationRequest(
        applicationName,
        currentApplicationVersionId
      )
    def applicationName: ApplicationName
    def currentApplicationVersionId: ApplicationVersionId
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getCurrentApplicationVersionId
        : ZIO[Any, Nothing, ApplicationVersionId] =
      ZIO.succeed(currentApplicationVersionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.RollbackApplicationRequest
  ) extends zio.aws.kinesisanalyticsv2.model.RollbackApplicationRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationName(impl.applicationName())
    override val currentApplicationVersionId: ApplicationVersionId =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationVersionId(impl.currentApplicationVersionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.RollbackApplicationRequest
  ): zio.aws.kinesisanalyticsv2.model.RollbackApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
