package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{LogStreamARN, Id}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CloudWatchLoggingOptionUpdate(
    cloudWatchLoggingOptionId: Id,
    logStreamARNUpdate: Optional[LogStreamARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.CloudWatchLoggingOptionUpdate = {
    import CloudWatchLoggingOptionUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CloudWatchLoggingOptionUpdate
      .builder()
      .cloudWatchLoggingOptionId(
        Id.unwrap(cloudWatchLoggingOptionId): java.lang.String
      )
      .optionallyWith(
        logStreamARNUpdate.map(value =>
          LogStreamARN.unwrap(value): java.lang.String
        )
      )(_.logStreamARNUpdate)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionUpdate.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionUpdate
      .wrap(buildAwsValue())
}
object CloudWatchLoggingOptionUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CloudWatchLoggingOptionUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionUpdate =
      zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionUpdate(
        cloudWatchLoggingOptionId,
        logStreamARNUpdate.map(value => value)
      )
    def cloudWatchLoggingOptionId: Id
    def logStreamARNUpdate: Optional[LogStreamARN]
    def getCloudWatchLoggingOptionId: ZIO[Any, Nothing, Id] =
      ZIO.succeed(cloudWatchLoggingOptionId)
    def getLogStreamARNUpdate: ZIO[Any, AwsError, LogStreamARN] =
      AwsError.unwrapOptionField("logStreamARNUpdate", logStreamARNUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CloudWatchLoggingOptionUpdate
  ) extends zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionUpdate.ReadOnly {
    override val cloudWatchLoggingOptionId: Id =
      zio.aws.kinesisanalyticsv2.model.primitives
        .Id(impl.cloudWatchLoggingOptionId())
    override val logStreamARNUpdate: Optional[LogStreamARN] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logStreamARNUpdate())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.primitives.LogStreamARN(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CloudWatchLoggingOptionUpdate
  ): zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionUpdate.ReadOnly =
    new Wrapper(impl)
}
