package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  SecurityGroupId,
  SubnetId,
  VpcId,
  Id
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class VpcConfigurationDescription(
    vpcConfigurationId: Id,
    vpcId: VpcId,
    subnetIds: Iterable[SubnetId],
    securityGroupIds: Iterable[SecurityGroupId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.VpcConfigurationDescription = {
    import VpcConfigurationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.VpcConfigurationDescription
      .builder()
      .vpcConfigurationId(Id.unwrap(vpcConfigurationId): java.lang.String)
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .subnetIds(subnetIds.map { item =>
        SubnetId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .securityGroupIds(securityGroupIds.map { item =>
        SecurityGroupId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.VpcConfigurationDescription.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.VpcConfigurationDescription
      .wrap(buildAwsValue())
}
object VpcConfigurationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.VpcConfigurationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.VpcConfigurationDescription =
      zio.aws.kinesisanalyticsv2.model.VpcConfigurationDescription(
        vpcConfigurationId,
        vpcId,
        subnetIds,
        securityGroupIds
      )
    def vpcConfigurationId: Id
    def vpcId: VpcId
    def subnetIds: List[SubnetId]
    def securityGroupIds: List[SecurityGroupId]
    def getVpcConfigurationId: ZIO[Any, Nothing, Id] =
      ZIO.succeed(vpcConfigurationId)
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
    def getSubnetIds: ZIO[Any, Nothing, List[SubnetId]] = ZIO.succeed(subnetIds)
    def getSecurityGroupIds: ZIO[Any, Nothing, List[SecurityGroupId]] =
      ZIO.succeed(securityGroupIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.VpcConfigurationDescription
  ) extends zio.aws.kinesisanalyticsv2.model.VpcConfigurationDescription.ReadOnly {
    override val vpcConfigurationId: Id =
      zio.aws.kinesisanalyticsv2.model.primitives.Id(impl.vpcConfigurationId())
    override val vpcId: VpcId =
      zio.aws.kinesisanalyticsv2.model.primitives.VpcId(impl.vpcId())
    override val subnetIds: List[SubnetId] = impl
      .subnetIds()
      .asScala
      .map { item =>
        zio.aws.kinesisanalyticsv2.model.primitives.SubnetId(item)
      }
      .toList
    override val securityGroupIds: List[SecurityGroupId] = impl
      .securityGroupIds()
      .asScala
      .map { item =>
        zio.aws.kinesisanalyticsv2.model.primitives.SecurityGroupId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.VpcConfigurationDescription
  ): zio.aws.kinesisanalyticsv2.model.VpcConfigurationDescription.ReadOnly =
    new Wrapper(impl)
}
