package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{FileKey, BucketARN}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class S3ReferenceDataSource(
    bucketARN: Optional[BucketARN] = Optional.Absent,
    fileKey: Optional[FileKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ReferenceDataSource = {
    import S3ReferenceDataSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ReferenceDataSource
      .builder()
      .optionallyWith(
        bucketARN.map(value => BucketARN.unwrap(value): java.lang.String)
      )(_.bucketARN)
      .optionallyWith(
        fileKey.map(value => FileKey.unwrap(value): java.lang.String)
      )(_.fileKey)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.S3ReferenceDataSource.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.S3ReferenceDataSource.wrap(buildAwsValue())
}
object S3ReferenceDataSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ReferenceDataSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.S3ReferenceDataSource =
      zio.aws.kinesisanalyticsv2.model.S3ReferenceDataSource(
        bucketARN.map(value => value),
        fileKey.map(value => value)
      )
    def bucketARN: Optional[BucketARN]
    def fileKey: Optional[FileKey]
    def getBucketARN: ZIO[Any, AwsError, BucketARN] =
      AwsError.unwrapOptionField("bucketARN", bucketARN)
    def getFileKey: ZIO[Any, AwsError, FileKey] =
      AwsError.unwrapOptionField("fileKey", fileKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ReferenceDataSource
  ) extends zio.aws.kinesisanalyticsv2.model.S3ReferenceDataSource.ReadOnly {
    override val bucketARN: Optional[BucketARN] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketARN())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.BucketARN(value)
      )
    override val fileKey: Optional[FileKey] = zio.aws.core.internal
      .optionalFromNullable(impl.fileKey())
      .map(value => zio.aws.kinesisanalyticsv2.model.primitives.FileKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ReferenceDataSource
  ): zio.aws.kinesisanalyticsv2.model.S3ReferenceDataSource.ReadOnly =
    new Wrapper(impl)
}
