package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeployAsApplicationConfigurationUpdate(
    s3ContentLocationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.S3ContentBaseLocationUpdate
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.DeployAsApplicationConfigurationUpdate = {
    import DeployAsApplicationConfigurationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.DeployAsApplicationConfigurationUpdate
      .builder()
      .optionallyWith(
        s3ContentLocationUpdate.map(value => value.buildAwsValue())
      )(_.s3ContentLocationUpdate)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.DeployAsApplicationConfigurationUpdate.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.DeployAsApplicationConfigurationUpdate
      .wrap(buildAwsValue())
}
object DeployAsApplicationConfigurationUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.DeployAsApplicationConfigurationUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.DeployAsApplicationConfigurationUpdate =
      zio.aws.kinesisanalyticsv2.model.DeployAsApplicationConfigurationUpdate(
        s3ContentLocationUpdate.map(value => value.asEditable)
      )
    def s3ContentLocationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.S3ContentBaseLocationUpdate.ReadOnly
    ]
    def getS3ContentLocationUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.S3ContentBaseLocationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "s3ContentLocationUpdate",
      s3ContentLocationUpdate
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.DeployAsApplicationConfigurationUpdate
  ) extends zio.aws.kinesisanalyticsv2.model.DeployAsApplicationConfigurationUpdate.ReadOnly {
    override val s3ContentLocationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.S3ContentBaseLocationUpdate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.s3ContentLocationUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.S3ContentBaseLocationUpdate.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.DeployAsApplicationConfigurationUpdate
  ): zio.aws.kinesisanalyticsv2.model.DeployAsApplicationConfigurationUpdate.ReadOnly =
    new Wrapper(impl)
}
