package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  SecurityGroupId,
  SubnetId,
  Id
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VpcConfigurationUpdate(
    vpcConfigurationId: Id,
    subnetIdUpdates: Optional[Iterable[SubnetId]] = Optional.Absent,
    securityGroupIdUpdates: Optional[Iterable[SecurityGroupId]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.VpcConfigurationUpdate = {
    import VpcConfigurationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.VpcConfigurationUpdate
      .builder()
      .vpcConfigurationId(Id.unwrap(vpcConfigurationId): java.lang.String)
      .optionallyWith(
        subnetIdUpdates.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIdUpdates)
      .optionallyWith(
        securityGroupIdUpdates.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIdUpdates)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.VpcConfigurationUpdate.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.VpcConfigurationUpdate
      .wrap(buildAwsValue())
}
object VpcConfigurationUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.VpcConfigurationUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.VpcConfigurationUpdate =
      zio.aws.kinesisanalyticsv2.model.VpcConfigurationUpdate(
        vpcConfigurationId,
        subnetIdUpdates.map(value => value),
        securityGroupIdUpdates.map(value => value)
      )
    def vpcConfigurationId: Id
    def subnetIdUpdates: Optional[List[SubnetId]]
    def securityGroupIdUpdates: Optional[List[SecurityGroupId]]
    def getVpcConfigurationId: ZIO[Any, Nothing, Id] =
      ZIO.succeed(vpcConfigurationId)
    def getSubnetIdUpdates: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnetIdUpdates", subnetIdUpdates)
    def getSecurityGroupIdUpdates: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField(
        "securityGroupIdUpdates",
        securityGroupIdUpdates
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.VpcConfigurationUpdate
  ) extends zio.aws.kinesisanalyticsv2.model.VpcConfigurationUpdate.ReadOnly {
    override val vpcConfigurationId: Id =
      zio.aws.kinesisanalyticsv2.model.primitives.Id(impl.vpcConfigurationId())
    override val subnetIdUpdates: Optional[List[SubnetId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnetIdUpdates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kinesisanalyticsv2.model.primitives.SubnetId(item)
          }.toList
        )
    override val securityGroupIdUpdates: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIdUpdates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kinesisanalyticsv2.model.primitives.SecurityGroupId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.VpcConfigurationUpdate
  ): zio.aws.kinesisanalyticsv2.model.VpcConfigurationUpdate.ReadOnly =
    new Wrapper(impl)
}
