package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.ResourceARN
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class KinesisStreamsOutputUpdate(resourceARNUpdate: ResourceARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisStreamsOutputUpdate = {
    import KinesisStreamsOutputUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisStreamsOutputUpdate
      .builder()
      .resourceARNUpdate(
        ResourceARN.unwrap(resourceARNUpdate): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.KinesisStreamsOutputUpdate.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.KinesisStreamsOutputUpdate
      .wrap(buildAwsValue())
}
object KinesisStreamsOutputUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisStreamsOutputUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.KinesisStreamsOutputUpdate =
      zio.aws.kinesisanalyticsv2.model
        .KinesisStreamsOutputUpdate(resourceARNUpdate)
    def resourceARNUpdate: ResourceARN
    def getResourceARNUpdate: ZIO[Any, Nothing, ResourceARN] =
      ZIO.succeed(resourceARNUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisStreamsOutputUpdate
  ) extends zio.aws.kinesisanalyticsv2.model.KinesisStreamsOutputUpdate.ReadOnly {
    override val resourceARNUpdate: ResourceARN =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ResourceARN(impl.resourceARNUpdate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisStreamsOutputUpdate
  ): zio.aws.kinesisanalyticsv2.model.KinesisStreamsOutputUpdate.ReadOnly =
    new Wrapper(impl)
}
