package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeployAsApplicationConfiguration(
    s3ContentLocation: zio.aws.kinesisanalyticsv2.model.S3ContentBaseLocation
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.DeployAsApplicationConfiguration = {
    import DeployAsApplicationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.DeployAsApplicationConfiguration
      .builder()
      .s3ContentLocation(s3ContentLocation.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.DeployAsApplicationConfiguration.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.DeployAsApplicationConfiguration
      .wrap(buildAwsValue())
}
object DeployAsApplicationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.DeployAsApplicationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.DeployAsApplicationConfiguration =
      zio.aws.kinesisanalyticsv2.model
        .DeployAsApplicationConfiguration(s3ContentLocation.asEditable)
    def s3ContentLocation
        : zio.aws.kinesisanalyticsv2.model.S3ContentBaseLocation.ReadOnly
    def getS3ContentLocation: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalyticsv2.model.S3ContentBaseLocation.ReadOnly
    ] = ZIO.succeed(s3ContentLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.DeployAsApplicationConfiguration
  ) extends zio.aws.kinesisanalyticsv2.model.DeployAsApplicationConfiguration.ReadOnly {
    override val s3ContentLocation
        : zio.aws.kinesisanalyticsv2.model.S3ContentBaseLocation.ReadOnly =
      zio.aws.kinesisanalyticsv2.model.S3ContentBaseLocation
        .wrap(impl.s3ContentLocation())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.DeployAsApplicationConfiguration
  ): zio.aws.kinesisanalyticsv2.model.DeployAsApplicationConfiguration.ReadOnly =
    new Wrapper(impl)
}
