package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ZeppelinApplicationConfigurationDescription(
    monitoringConfigurationDescription: zio.aws.kinesisanalyticsv2.model.ZeppelinMonitoringConfigurationDescription,
    catalogConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.CatalogConfigurationDescription
    ] = None,
    deployAsApplicationConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.DeployAsApplicationConfigurationDescription
    ] = None,
    customArtifactsConfigurationDescription: Option[Iterable[
      zio.aws.kinesisanalyticsv2.model.CustomArtifactConfigurationDescription
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationDescription = {
    import ZeppelinApplicationConfigurationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationDescription
      .builder()
      .monitoringConfigurationDescription(
        monitoringConfigurationDescription.buildAwsValue()
      )
      .optionallyWith(
        catalogConfigurationDescription.map(value => value.buildAwsValue())
      )(_.catalogConfigurationDescription)
      .optionallyWith(
        deployAsApplicationConfigurationDescription.map(value =>
          value.buildAwsValue()
        )
      )(_.deployAsApplicationConfigurationDescription)
      .optionallyWith(
        customArtifactsConfigurationDescription.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customArtifactsConfigurationDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationDescription.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationDescription
      .wrap(buildAwsValue())
}
object ZeppelinApplicationConfigurationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationDescription =
      zio.aws.kinesisanalyticsv2.model
        .ZeppelinApplicationConfigurationDescription(
          monitoringConfigurationDescription.asEditable,
          catalogConfigurationDescription.map(value => value.asEditable),
          deployAsApplicationConfigurationDescription.map(value =>
            value.asEditable
          ),
          customArtifactsConfigurationDescription.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def monitoringConfigurationDescription
        : zio.aws.kinesisanalyticsv2.model.ZeppelinMonitoringConfigurationDescription.ReadOnly
    def catalogConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.CatalogConfigurationDescription.ReadOnly
    ]
    def deployAsApplicationConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.DeployAsApplicationConfigurationDescription.ReadOnly
    ]
    def customArtifactsConfigurationDescription: Option[List[
      zio.aws.kinesisanalyticsv2.model.CustomArtifactConfigurationDescription.ReadOnly
    ]]
    def getMonitoringConfigurationDescription: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalyticsv2.model.ZeppelinMonitoringConfigurationDescription.ReadOnly
    ] = ZIO.succeed(monitoringConfigurationDescription)
    def getCatalogConfigurationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.CatalogConfigurationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "catalogConfigurationDescription",
      catalogConfigurationDescription
    )
    def getDeployAsApplicationConfigurationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.DeployAsApplicationConfigurationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "deployAsApplicationConfigurationDescription",
      deployAsApplicationConfigurationDescription
    )
    def getCustomArtifactsConfigurationDescription: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalyticsv2.model.CustomArtifactConfigurationDescription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "customArtifactsConfigurationDescription",
      customArtifactsConfigurationDescription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationDescription
  ) extends zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationDescription.ReadOnly {
    override val monitoringConfigurationDescription
        : zio.aws.kinesisanalyticsv2.model.ZeppelinMonitoringConfigurationDescription.ReadOnly =
      zio.aws.kinesisanalyticsv2.model.ZeppelinMonitoringConfigurationDescription
        .wrap(impl.monitoringConfigurationDescription())
    override val catalogConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.CatalogConfigurationDescription.ReadOnly
    ] = scala
      .Option(impl.catalogConfigurationDescription())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.CatalogConfigurationDescription
          .wrap(value)
      )
    override val deployAsApplicationConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.DeployAsApplicationConfigurationDescription.ReadOnly
    ] = scala
      .Option(impl.deployAsApplicationConfigurationDescription())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.DeployAsApplicationConfigurationDescription
          .wrap(value)
      )
    override val customArtifactsConfigurationDescription: Option[List[
      zio.aws.kinesisanalyticsv2.model.CustomArtifactConfigurationDescription.ReadOnly
    ]] = scala
      .Option(impl.customArtifactsConfigurationDescription())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalyticsv2.model.CustomArtifactConfigurationDescription
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationDescription
  ): zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationDescription.ReadOnly =
    new Wrapper(impl)
}
