package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.ResourceARN
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class InputLambdaProcessorUpdate(resourceARNUpdate: ResourceARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.InputLambdaProcessorUpdate = {
    import InputLambdaProcessorUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.InputLambdaProcessorUpdate
      .builder()
      .resourceARNUpdate(
        ResourceARN.unwrap(resourceARNUpdate): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.InputLambdaProcessorUpdate.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.InputLambdaProcessorUpdate
      .wrap(buildAwsValue())
}
object InputLambdaProcessorUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.InputLambdaProcessorUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.InputLambdaProcessorUpdate =
      zio.aws.kinesisanalyticsv2.model
        .InputLambdaProcessorUpdate(resourceARNUpdate)
    def resourceARNUpdate: ResourceARN
    def getResourceARNUpdate: ZIO[Any, Nothing, ResourceARN] =
      ZIO.succeed(resourceARNUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.InputLambdaProcessorUpdate
  ) extends zio.aws.kinesisanalyticsv2.model.InputLambdaProcessorUpdate.ReadOnly {
    override val resourceARNUpdate: ResourceARN =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ResourceARN(impl.resourceARNUpdate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.InputLambdaProcessorUpdate
  ): zio.aws.kinesisanalyticsv2.model.InputLambdaProcessorUpdate.ReadOnly =
    new Wrapper(impl)
}
