package zio.aws.kinesisanalyticsv2.model
import scala.jdk.CollectionConverters.*
sealed trait ConfigurationType {
  def unwrap: software.amazon.awssdk.services.kinesisanalyticsv2.model.ConfigurationType
}
object ConfigurationType {
  def wrap(
      value: software.amazon.awssdk.services.kinesisanalyticsv2.model.ConfigurationType
  ): zio.aws.kinesisanalyticsv2.model.ConfigurationType = value match {
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.ConfigurationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.ConfigurationType.DEFAULT =>
      val r = DEFAULT
      r
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.ConfigurationType.CUSTOM =>
      val r = CUSTOM
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kinesisanalyticsv2.model.ConfigurationType {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.ConfigurationType =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.ConfigurationType.UNKNOWN_TO_SDK_VERSION
  }
  case object DEFAULT
      extends zio.aws.kinesisanalyticsv2.model.ConfigurationType {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.ConfigurationType =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.ConfigurationType.DEFAULT
  }
  case object CUSTOM
      extends zio.aws.kinesisanalyticsv2.model.ConfigurationType {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.ConfigurationType =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.ConfigurationType.CUSTOM
  }
}
