package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.ApplicationVersionId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ApplicationVersionSummary(
    applicationVersionId: ApplicationVersionId,
    applicationStatus: zio.aws.kinesisanalyticsv2.model.ApplicationStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationVersionSummary = {
    import ApplicationVersionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationVersionSummary
      .builder()
      .applicationVersionId(
        ApplicationVersionId.unwrap(applicationVersionId): java.lang.Long
      )
      .applicationStatus(applicationStatus.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.ApplicationVersionSummary.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.ApplicationVersionSummary
      .wrap(buildAwsValue())
}
object ApplicationVersionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationVersionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.ApplicationVersionSummary =
      zio.aws.kinesisanalyticsv2.model
        .ApplicationVersionSummary(applicationVersionId, applicationStatus)
    def applicationVersionId: ApplicationVersionId
    def applicationStatus: zio.aws.kinesisanalyticsv2.model.ApplicationStatus
    def getApplicationVersionId: ZIO[Any, Nothing, ApplicationVersionId] =
      ZIO.succeed(applicationVersionId)
    def getApplicationStatus: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalyticsv2.model.ApplicationStatus
    ] = ZIO.succeed(applicationStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationVersionSummary
  ) extends zio.aws.kinesisanalyticsv2.model.ApplicationVersionSummary.ReadOnly {
    override val applicationVersionId: ApplicationVersionId =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationVersionId(impl.applicationVersionId())
    override val applicationStatus
        : zio.aws.kinesisanalyticsv2.model.ApplicationStatus =
      zio.aws.kinesisanalyticsv2.model.ApplicationStatus
        .wrap(impl.applicationStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationVersionSummary
  ): zio.aws.kinesisanalyticsv2.model.ApplicationVersionSummary.ReadOnly =
    new Wrapper(impl)
}
