package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  ApplicationVersionId,
  ResourceARN
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AddApplicationVpcConfigurationResponse(
    applicationARN: Option[ResourceARN] = None,
    applicationVersionId: Option[ApplicationVersionId] = None,
    vpcConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.VpcConfigurationDescription
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationVpcConfigurationResponse = {
    import AddApplicationVpcConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationVpcConfigurationResponse
      .builder()
      .optionallyWith(
        applicationARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.applicationARN)
      .optionallyWith(
        applicationVersionId.map(value =>
          ApplicationVersionId.unwrap(value): java.lang.Long
        )
      )(_.applicationVersionId)
      .optionallyWith(
        vpcConfigurationDescription.map(value => value.buildAwsValue())
      )(_.vpcConfigurationDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.AddApplicationVpcConfigurationResponse.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.AddApplicationVpcConfigurationResponse
      .wrap(buildAwsValue())
}
object AddApplicationVpcConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationVpcConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.AddApplicationVpcConfigurationResponse =
      zio.aws.kinesisanalyticsv2.model.AddApplicationVpcConfigurationResponse(
        applicationARN.map(value => value),
        applicationVersionId.map(value => value),
        vpcConfigurationDescription.map(value => value.asEditable)
      )
    def applicationARN: Option[ResourceARN]
    def applicationVersionId: Option[ApplicationVersionId]
    def vpcConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.VpcConfigurationDescription.ReadOnly
    ]
    def getApplicationARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("applicationARN", applicationARN)
    def getApplicationVersionId: ZIO[Any, AwsError, ApplicationVersionId] =
      AwsError.unwrapOptionField("applicationVersionId", applicationVersionId)
    def getVpcConfigurationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.VpcConfigurationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "vpcConfigurationDescription",
      vpcConfigurationDescription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationVpcConfigurationResponse
  ) extends zio.aws.kinesisanalyticsv2.model.AddApplicationVpcConfigurationResponse.ReadOnly {
    override val applicationARN: Option[ResourceARN] = scala
      .Option(impl.applicationARN())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.ResourceARN(value)
      )
    override val applicationVersionId: Option[ApplicationVersionId] = scala
      .Option(impl.applicationVersionId())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.ApplicationVersionId(value)
      )
    override val vpcConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.VpcConfigurationDescription.ReadOnly
    ] = scala
      .Option(impl.vpcConfigurationDescription())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.VpcConfigurationDescription.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationVpcConfigurationResponse
  ): zio.aws.kinesisanalyticsv2.model.AddApplicationVpcConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
