package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{InAppStreamName, Id}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class OutputUpdate(
    outputId: Id,
    nameUpdate: Option[InAppStreamName] = None,
    kinesisStreamsOutputUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.KinesisStreamsOutputUpdate
    ] = None,
    kinesisFirehoseOutputUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.KinesisFirehoseOutputUpdate
    ] = None,
    lambdaOutputUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.LambdaOutputUpdate
    ] = None,
    destinationSchemaUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.DestinationSchema
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.OutputUpdate = {
    import OutputUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.OutputUpdate
      .builder()
      .outputId(Id.unwrap(outputId): java.lang.String)
      .optionallyWith(
        nameUpdate.map(value => InAppStreamName.unwrap(value): java.lang.String)
      )(_.nameUpdate)
      .optionallyWith(
        kinesisStreamsOutputUpdate.map(value => value.buildAwsValue())
      )(_.kinesisStreamsOutputUpdate)
      .optionallyWith(
        kinesisFirehoseOutputUpdate.map(value => value.buildAwsValue())
      )(_.kinesisFirehoseOutputUpdate)
      .optionallyWith(lambdaOutputUpdate.map(value => value.buildAwsValue()))(
        _.lambdaOutputUpdate
      )
      .optionallyWith(
        destinationSchemaUpdate.map(value => value.buildAwsValue())
      )(_.destinationSchemaUpdate)
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalyticsv2.model.OutputUpdate.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.OutputUpdate.wrap(buildAwsValue())
}
object OutputUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.OutputUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.OutputUpdate =
      zio.aws.kinesisanalyticsv2.model.OutputUpdate(
        outputId,
        nameUpdate.map(value => value),
        kinesisStreamsOutputUpdate.map(value => value.asEditable),
        kinesisFirehoseOutputUpdate.map(value => value.asEditable),
        lambdaOutputUpdate.map(value => value.asEditable),
        destinationSchemaUpdate.map(value => value.asEditable)
      )
    def outputId: Id
    def nameUpdate: Option[InAppStreamName]
    def kinesisStreamsOutputUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.KinesisStreamsOutputUpdate.ReadOnly
    ]
    def kinesisFirehoseOutputUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.KinesisFirehoseOutputUpdate.ReadOnly
    ]
    def lambdaOutputUpdate
        : Option[zio.aws.kinesisanalyticsv2.model.LambdaOutputUpdate.ReadOnly]
    def destinationSchemaUpdate
        : Option[zio.aws.kinesisanalyticsv2.model.DestinationSchema.ReadOnly]
    def getOutputId: ZIO[Any, Nothing, Id] = ZIO.succeed(outputId)
    def getNameUpdate: ZIO[Any, AwsError, InAppStreamName] =
      AwsError.unwrapOptionField("nameUpdate", nameUpdate)
    def getKinesisStreamsOutputUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.KinesisStreamsOutputUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kinesisStreamsOutputUpdate",
      kinesisStreamsOutputUpdate
    )
    def getKinesisFirehoseOutputUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.KinesisFirehoseOutputUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kinesisFirehoseOutputUpdate",
      kinesisFirehoseOutputUpdate
    )
    def getLambdaOutputUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.LambdaOutputUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("lambdaOutputUpdate", lambdaOutputUpdate)
    def getDestinationSchemaUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.DestinationSchema.ReadOnly
    ] = AwsError.unwrapOptionField(
      "destinationSchemaUpdate",
      destinationSchemaUpdate
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.OutputUpdate
  ) extends zio.aws.kinesisanalyticsv2.model.OutputUpdate.ReadOnly {
    override val outputId: Id =
      zio.aws.kinesisanalyticsv2.model.primitives.Id(impl.outputId())
    override val nameUpdate: Option[InAppStreamName] = scala
      .Option(impl.nameUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.InAppStreamName(value)
      )
    override val kinesisStreamsOutputUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.KinesisStreamsOutputUpdate.ReadOnly
    ] = scala
      .Option(impl.kinesisStreamsOutputUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.KinesisStreamsOutputUpdate.wrap(value)
      )
    override val kinesisFirehoseOutputUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.KinesisFirehoseOutputUpdate.ReadOnly
    ] = scala
      .Option(impl.kinesisFirehoseOutputUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.KinesisFirehoseOutputUpdate.wrap(value)
      )
    override val lambdaOutputUpdate
        : Option[zio.aws.kinesisanalyticsv2.model.LambdaOutputUpdate.ReadOnly] =
      scala
        .Option(impl.lambdaOutputUpdate())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.LambdaOutputUpdate.wrap(value)
        )
    override val destinationSchemaUpdate
        : Option[zio.aws.kinesisanalyticsv2.model.DestinationSchema.ReadOnly] =
      scala
        .Option(impl.destinationSchemaUpdate())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.DestinationSchema.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.OutputUpdate
  ): zio.aws.kinesisanalyticsv2.model.OutputUpdate.ReadOnly = new Wrapper(impl)
}
