package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.RecordEncoding
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class InputSchemaUpdate(
    recordFormatUpdate: Option[zio.aws.kinesisanalyticsv2.model.RecordFormat] =
      None,
    recordEncodingUpdate: Option[RecordEncoding] = None,
    recordColumnUpdates: Option[
      Iterable[zio.aws.kinesisanalyticsv2.model.RecordColumn]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.InputSchemaUpdate = {
    import InputSchemaUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.InputSchemaUpdate
      .builder()
      .optionallyWith(recordFormatUpdate.map(value => value.buildAwsValue()))(
        _.recordFormatUpdate
      )
      .optionallyWith(
        recordEncodingUpdate.map(value =>
          RecordEncoding.unwrap(value): java.lang.String
        )
      )(_.recordEncodingUpdate)
      .optionallyWith(
        recordColumnUpdates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recordColumnUpdates)
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalyticsv2.model.InputSchemaUpdate.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.InputSchemaUpdate.wrap(buildAwsValue())
}
object InputSchemaUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.InputSchemaUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.InputSchemaUpdate =
      zio.aws.kinesisanalyticsv2.model.InputSchemaUpdate(
        recordFormatUpdate.map(value => value.asEditable),
        recordEncodingUpdate.map(value => value),
        recordColumnUpdates.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def recordFormatUpdate
        : Option[zio.aws.kinesisanalyticsv2.model.RecordFormat.ReadOnly]
    def recordEncodingUpdate: Option[RecordEncoding]
    def recordColumnUpdates
        : Option[List[zio.aws.kinesisanalyticsv2.model.RecordColumn.ReadOnly]]
    def getRecordFormatUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.RecordFormat.ReadOnly
    ] = AwsError.unwrapOptionField("recordFormatUpdate", recordFormatUpdate)
    def getRecordEncodingUpdate: ZIO[Any, AwsError, RecordEncoding] =
      AwsError.unwrapOptionField("recordEncodingUpdate", recordEncodingUpdate)
    def getRecordColumnUpdates: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalyticsv2.model.RecordColumn.ReadOnly
    ]] = AwsError.unwrapOptionField("recordColumnUpdates", recordColumnUpdates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.InputSchemaUpdate
  ) extends zio.aws.kinesisanalyticsv2.model.InputSchemaUpdate.ReadOnly {
    override val recordFormatUpdate
        : Option[zio.aws.kinesisanalyticsv2.model.RecordFormat.ReadOnly] = scala
      .Option(impl.recordFormatUpdate())
      .map(value => zio.aws.kinesisanalyticsv2.model.RecordFormat.wrap(value))
    override val recordEncodingUpdate: Option[RecordEncoding] = scala
      .Option(impl.recordEncodingUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.RecordEncoding(value)
      )
    override val recordColumnUpdates
        : Option[List[zio.aws.kinesisanalyticsv2.model.RecordColumn.ReadOnly]] =
      scala
        .Option(impl.recordColumnUpdates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kinesisanalyticsv2.model.RecordColumn.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.InputSchemaUpdate
  ): zio.aws.kinesisanalyticsv2.model.InputSchemaUpdate.ReadOnly = new Wrapper(
    impl
  )
}
