package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class InputProcessingConfiguration(
    inputLambdaProcessor: zio.aws.kinesisanalyticsv2.model.InputLambdaProcessor
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.InputProcessingConfiguration = {
    import InputProcessingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.InputProcessingConfiguration
      .builder()
      .inputLambdaProcessor(inputLambdaProcessor.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.InputProcessingConfiguration.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.InputProcessingConfiguration
      .wrap(buildAwsValue())
}
object InputProcessingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.InputProcessingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.InputProcessingConfiguration =
      zio.aws.kinesisanalyticsv2.model
        .InputProcessingConfiguration(inputLambdaProcessor.asEditable)
    def inputLambdaProcessor
        : zio.aws.kinesisanalyticsv2.model.InputLambdaProcessor.ReadOnly
    def getInputLambdaProcessor: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalyticsv2.model.InputLambdaProcessor.ReadOnly
    ] = ZIO.succeed(inputLambdaProcessor)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.InputProcessingConfiguration
  ) extends zio.aws.kinesisanalyticsv2.model.InputProcessingConfiguration.ReadOnly {
    override val inputLambdaProcessor
        : zio.aws.kinesisanalyticsv2.model.InputLambdaProcessor.ReadOnly =
      zio.aws.kinesisanalyticsv2.model.InputLambdaProcessor
        .wrap(impl.inputLambdaProcessor())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.InputProcessingConfiguration
  ): zio.aws.kinesisanalyticsv2.model.InputProcessingConfiguration.ReadOnly =
    new Wrapper(impl)
}
