package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  BooleanObject,
  ApplicationName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StopApplicationRequest(
    applicationName: ApplicationName,
    force: Option[BooleanObject] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.StopApplicationRequest = {
    import StopApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.StopApplicationRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .optionallyWith(force.map(value => value: java.lang.Boolean))(_.force)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.StopApplicationRequest.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.StopApplicationRequest
      .wrap(buildAwsValue())
}
object StopApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.StopApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.StopApplicationRequest =
      zio.aws.kinesisanalyticsv2.model
        .StopApplicationRequest(applicationName, force.map(value => value))
    def applicationName: ApplicationName
    def force: Option[BooleanObject]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getForce: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("force", force)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.StopApplicationRequest
  ) extends zio.aws.kinesisanalyticsv2.model.StopApplicationRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationName(impl.applicationName())
    override val force: Option[BooleanObject] =
      scala.Option(impl.force()).map(value => value: BooleanObject)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.StopApplicationRequest
  ): zio.aws.kinesisanalyticsv2.model.StopApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
