package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SqlApplicationConfigurationUpdate(
    inputUpdates: Option[
      Iterable[zio.aws.kinesisanalyticsv2.model.InputUpdate]
    ] = None,
    outputUpdates: Option[
      Iterable[zio.aws.kinesisanalyticsv2.model.OutputUpdate]
    ] = None,
    referenceDataSourceUpdates: Option[
      Iterable[zio.aws.kinesisanalyticsv2.model.ReferenceDataSourceUpdate]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.SqlApplicationConfigurationUpdate = {
    import SqlApplicationConfigurationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.SqlApplicationConfigurationUpdate
      .builder()
      .optionallyWith(
        inputUpdates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputUpdates)
      .optionallyWith(
        outputUpdates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputUpdates)
      .optionallyWith(
        referenceDataSourceUpdates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.referenceDataSourceUpdates)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.SqlApplicationConfigurationUpdate.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.SqlApplicationConfigurationUpdate
      .wrap(buildAwsValue())
}
object SqlApplicationConfigurationUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.SqlApplicationConfigurationUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.SqlApplicationConfigurationUpdate =
      zio.aws.kinesisanalyticsv2.model.SqlApplicationConfigurationUpdate(
        inputUpdates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        outputUpdates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        referenceDataSourceUpdates.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def inputUpdates
        : Option[List[zio.aws.kinesisanalyticsv2.model.InputUpdate.ReadOnly]]
    def outputUpdates
        : Option[List[zio.aws.kinesisanalyticsv2.model.OutputUpdate.ReadOnly]]
    def referenceDataSourceUpdates: Option[
      List[zio.aws.kinesisanalyticsv2.model.ReferenceDataSourceUpdate.ReadOnly]
    ]
    def getInputUpdates: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalyticsv2.model.InputUpdate.ReadOnly
    ]] = AwsError.unwrapOptionField("inputUpdates", inputUpdates)
    def getOutputUpdates: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalyticsv2.model.OutputUpdate.ReadOnly
    ]] = AwsError.unwrapOptionField("outputUpdates", outputUpdates)
    def getReferenceDataSourceUpdates: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalyticsv2.model.ReferenceDataSourceUpdate.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "referenceDataSourceUpdates",
      referenceDataSourceUpdates
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.SqlApplicationConfigurationUpdate
  ) extends zio.aws.kinesisanalyticsv2.model.SqlApplicationConfigurationUpdate.ReadOnly {
    override val inputUpdates
        : Option[List[zio.aws.kinesisanalyticsv2.model.InputUpdate.ReadOnly]] =
      scala
        .Option(impl.inputUpdates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kinesisanalyticsv2.model.InputUpdate.wrap(item)
          }.toList
        )
    override val outputUpdates
        : Option[List[zio.aws.kinesisanalyticsv2.model.OutputUpdate.ReadOnly]] =
      scala
        .Option(impl.outputUpdates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kinesisanalyticsv2.model.OutputUpdate.wrap(item)
          }.toList
        )
    override val referenceDataSourceUpdates: Option[
      List[zio.aws.kinesisanalyticsv2.model.ReferenceDataSourceUpdate.ReadOnly]
    ] = scala
      .Option(impl.referenceDataSourceUpdates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalyticsv2.model.ReferenceDataSourceUpdate.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.SqlApplicationConfigurationUpdate
  ): zio.aws.kinesisanalyticsv2.model.SqlApplicationConfigurationUpdate.ReadOnly =
    new Wrapper(impl)
}
