package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.DatabaseARN
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GlueDataCatalogConfigurationUpdate(
    databaseARNUpdate: DatabaseARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.GlueDataCatalogConfigurationUpdate = {
    import GlueDataCatalogConfigurationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.GlueDataCatalogConfigurationUpdate
      .builder()
      .databaseARNUpdate(
        DatabaseARN.unwrap(databaseARNUpdate): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.GlueDataCatalogConfigurationUpdate.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.GlueDataCatalogConfigurationUpdate
      .wrap(buildAwsValue())
}
object GlueDataCatalogConfigurationUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.GlueDataCatalogConfigurationUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.GlueDataCatalogConfigurationUpdate =
      zio.aws.kinesisanalyticsv2.model
        .GlueDataCatalogConfigurationUpdate(databaseARNUpdate)
    def databaseARNUpdate: DatabaseARN
    def getDatabaseARNUpdate: ZIO[Any, Nothing, DatabaseARN] =
      ZIO.succeed(databaseARNUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.GlueDataCatalogConfigurationUpdate
  ) extends zio.aws.kinesisanalyticsv2.model.GlueDataCatalogConfigurationUpdate.ReadOnly {
    override val databaseARNUpdate: DatabaseARN =
      zio.aws.kinesisanalyticsv2.model.primitives
        .DatabaseARN(impl.databaseARNUpdate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.GlueDataCatalogConfigurationUpdate
  ): zio.aws.kinesisanalyticsv2.model.GlueDataCatalogConfigurationUpdate.ReadOnly =
    new Wrapper(impl)
}
