package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeApplicationVersionResponse(
    applicationVersionDetail: Option[
      zio.aws.kinesisanalyticsv2.model.ApplicationDetail
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationVersionResponse = {
    import DescribeApplicationVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationVersionResponse
      .builder()
      .optionallyWith(
        applicationVersionDetail.map(value => value.buildAwsValue())
      )(_.applicationVersionDetail)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.DescribeApplicationVersionResponse.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.DescribeApplicationVersionResponse
      .wrap(buildAwsValue())
}
object DescribeApplicationVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.DescribeApplicationVersionResponse =
      zio.aws.kinesisanalyticsv2.model.DescribeApplicationVersionResponse(
        applicationVersionDetail.map(value => value.asEditable)
      )
    def applicationVersionDetail
        : Option[zio.aws.kinesisanalyticsv2.model.ApplicationDetail.ReadOnly]
    def getApplicationVersionDetail: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ApplicationDetail.ReadOnly
    ] = AwsError.unwrapOptionField(
      "applicationVersionDetail",
      applicationVersionDetail
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationVersionResponse
  ) extends zio.aws.kinesisanalyticsv2.model.DescribeApplicationVersionResponse.ReadOnly {
    override val applicationVersionDetail
        : Option[zio.aws.kinesisanalyticsv2.model.ApplicationDetail.ReadOnly] =
      scala
        .Option(impl.applicationVersionDetail())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.ApplicationDetail.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationVersionResponse
  ): zio.aws.kinesisanalyticsv2.model.DescribeApplicationVersionResponse.ReadOnly =
    new Wrapper(impl)
}
