package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListApplicationSnapshotsResponse(
    snapshotSummaries: Option[
      Iterable[zio.aws.kinesisanalyticsv2.model.SnapshotDetails]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsResponse = {
    import ListApplicationSnapshotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsResponse
      .builder()
      .optionallyWith(
        snapshotSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.snapshotSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.ListApplicationSnapshotsResponse.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.ListApplicationSnapshotsResponse
      .wrap(buildAwsValue())
}
object ListApplicationSnapshotsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.ListApplicationSnapshotsResponse =
      zio.aws.kinesisanalyticsv2.model.ListApplicationSnapshotsResponse(
        snapshotSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def snapshotSummaries: Option[
      List[zio.aws.kinesisanalyticsv2.model.SnapshotDetails.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getSnapshotSummaries: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalyticsv2.model.SnapshotDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("snapshotSummaries", snapshotSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsResponse
  ) extends zio.aws.kinesisanalyticsv2.model.ListApplicationSnapshotsResponse.ReadOnly {
    override val snapshotSummaries: Option[
      List[zio.aws.kinesisanalyticsv2.model.SnapshotDetails.ReadOnly]
    ] = scala
      .Option(impl.snapshotSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalyticsv2.model.SnapshotDetails.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsResponse
  ): zio.aws.kinesisanalyticsv2.model.ListApplicationSnapshotsResponse.ReadOnly =
    new Wrapper(impl)
}
