package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  ObjectVersion,
  FileKey,
  BucketARN
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class S3ApplicationCodeLocationDescription(
    bucketARN: BucketARN,
    fileKey: FileKey,
    objectVersion: Option[ObjectVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ApplicationCodeLocationDescription = {
    import S3ApplicationCodeLocationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ApplicationCodeLocationDescription
      .builder()
      .bucketARN(BucketARN.unwrap(bucketARN): java.lang.String)
      .fileKey(FileKey.unwrap(fileKey): java.lang.String)
      .optionallyWith(
        objectVersion.map(value =>
          ObjectVersion.unwrap(value): java.lang.String
        )
      )(_.objectVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.S3ApplicationCodeLocationDescription.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.S3ApplicationCodeLocationDescription
      .wrap(buildAwsValue())
}
object S3ApplicationCodeLocationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ApplicationCodeLocationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.S3ApplicationCodeLocationDescription =
      zio.aws.kinesisanalyticsv2.model.S3ApplicationCodeLocationDescription(
        bucketARN,
        fileKey,
        objectVersion.map(value => value)
      )
    def bucketARN: BucketARN
    def fileKey: FileKey
    def objectVersion: Option[ObjectVersion]
    def getBucketARN: ZIO[Any, Nothing, BucketARN] = ZIO.succeed(bucketARN)
    def getFileKey: ZIO[Any, Nothing, FileKey] = ZIO.succeed(fileKey)
    def getObjectVersion: ZIO[Any, AwsError, ObjectVersion] =
      AwsError.unwrapOptionField("objectVersion", objectVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ApplicationCodeLocationDescription
  ) extends zio.aws.kinesisanalyticsv2.model.S3ApplicationCodeLocationDescription.ReadOnly {
    override val bucketARN: BucketARN =
      zio.aws.kinesisanalyticsv2.model.primitives.BucketARN(impl.bucketARN())
    override val fileKey: FileKey =
      zio.aws.kinesisanalyticsv2.model.primitives.FileKey(impl.fileKey())
    override val objectVersion: Option[ObjectVersion] = scala
      .Option(impl.objectVersion())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.ObjectVersion(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ApplicationCodeLocationDescription
  ): zio.aws.kinesisanalyticsv2.model.S3ApplicationCodeLocationDescription.ReadOnly =
    new Wrapper(impl)
}
